
char buf1[0x4000]; // 通常エリア
char buf2[0x4000] __attribute__((section("AHBSRAM0"))); // Ethernet用エリア (0x2007c000)

#include <stdlib.h>
#include <string.h>
#include "xbee.h"
#include "MPU9250.h"
#include "mbed.h"

#define PI 3.14159265
#define A 6378137.000
#define B 6356752.314245
#define e2 0.006694379
#define m 6335439.327292
#define p 0.3  //ローパスフィルタの値
#define q 0.4  //ローパスフィルタの値
#define h 200  //pcのxbeeにプログラムの実行回数のうち何回に１回パソコンに送るかを決める値
#define hh 10   //相手機への通信をプログラムの実行回数のうち何回に１回を送るかを決める値

#define aa 11
#define bb 21
#define cc 31
#define aa_ 12
#define bb_ 22
#define cc_ 32

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut request(p11);
DigitalIn signal(p12);
Serial pc(USBTX, USBRX);
Serial sGps(p28, p27);
//RawSerial _xbee_serial(p9, p10);
SPI spi(p5, p6, p7);
mpu9250_spi imu(spi,p8);
Serial sbus(p13, p14);
Timer t, t2, anglesT;

double gyro[3],angles_before[3],angles[3],houi;
/*float m_min[] = {-35.921,   -33.910,   -41.263};                              //main
float m_max[] = {41.938,    44.207,    40.922}*/;
/*float m_min[] = {-53.086,   -38.526,   -54.392};
float m_max[] = {40.345,    49.356,    40.922};*/
/*float m_min[] = {-49.724,   -44.562,   -53.198};
float m_max[] = {37.514,    47.936,    45.867};*/
/*float m_min[] = {-51.493,   -43.675,   -52.687};
float m_max[] = {41.407,    44.207,    41.092};*///2020/10/21
/*float m_min[] = {-52.024,   -33.022,   -52.175};
float m_max[] = {40.876,    47.580,    42.797};*///2020/10/30
/*float m_min[] = {-50.609,   -43.320,   -49.277};
float m_max[] = {43.354,    48.113,    49.788}*/;//2020/11/11
/*float m_min[] = {-55.386,   -38.526,   -58.143};
float m_max[] = {40.876,    47.758,    38.876};*///2020/11/11  //2/8 change
float m_min[] = {-50.641,   -26.278,   -50.441};
float m_max[] = {40.547,    52.903,    39.548};//2020/2/8


float offsetM[3];
int i = 0, j = 0, k = 0;
double myLat_rad, myLong_rad, Latitude_rad, Longitude_rad;

double sekkin = 20.0, sekkin_hani = 40.0;

double Time, Lat, Long, heading;
double Timef, Latf, Longf, Heading;
double Lat_before, Latf_before, Long_before, Longf_before, Heading_before, distance_before, heading_before;
double distance, direction;
double to_Long, to_Lat;

double b_head, b_head_front, c_head_front;
double wp_distance, wp_direction, wp_head;
double range;
double heading0,heading1, heading2, heading3, heading4, heading5;
double Time_4,Time_3,Time_2,Time_1;


int rud = 1024, ele = 1024, ail = 1024;
double ele_dis = 0.0, ail_dis = 0.0;
int ele_range, ail_range;
int ele_before = 1024,ail_before = 1024;                                        //change
int count = 0;

//int marker, marker_me;

char sbus_from[6][6];
int channels_from[] = {1024,1024,1024,1024,1024,1541};
int channels_to[] = {1024,1024,1024,1024,1024,1541};
int not_use;
int through = 0, through_before = 0;
bool input_before = true;

/*XBee送受信関連*/
/*#define API_TXSIZE 255      // 送信用APIデータ長(32～255)
typedef unsigned char byte;

static byte PACKET_ID = 0;

static byte ADR_DEST[]=     {0x00,0x13,0xA2,0x00,0x00,0x00,0x00,0x00};  //宛先のIEEEアドレス(変更可)
static byte SADR_DEST[]=    {0xFF,0xFE};            //ブロード(ショート)アドレス
*/

/*void xbee_address(const byte *address){

//    処理：送信用の宛先アドレス設定用の関数
//    入力：byte *address = 宛先(子機)アドレス

    byte i;

    for(i=0; i< 8 ;i++ ) ADR_DEST[i] = address[i];
    SADR_DEST[0] = 0xFF;
    SADR_DEST[1] = 0xFE;
}*/

/* シリアル送受信バッファクリア */
/*void sci_clear(void){
    //while( _xbee_serial.readable() ){
    //    _xbee_serial.getc();
    //    wait(0.002);
    //}
    while( !_xbee_serial.writeable() ){
        _xbee_serial.send_break();
        //wait(1);
    }
}*/

/*byte sci_write_check(void){
    if( !_xbee_serial.writeable() ){
        //wait(0.1);
        while( !_xbee_serial.writeable() ) sci_clear();
    }

    return( 1 );
}*/

/*byte sci_write( char *data, byte len ){
    byte ret=1; // 戻り値 0でエラー

    byte i;
    sci_write_check();
    for(i=0;i<len;i++){
        if( _xbee_serial.putc((int)data[i]) < 0 ) ret=0;
    }
    if(ret) ret=len;
        
    return( ret );
}*/

/*byte xbee_at_tx(const char *at, const byte *value, const byte value_len){

//    処理：リモートＡＴコマンドの送信を行うXBeeドライバ部
//    入力：ATコマンドat[] ＝ "AT**"はローカルATで、"RAT***"がリモートＡＴ
//    　　　　　　　　　　　　TXがデータ送信モード
//    　　　データvalue[]　＝ 各ＡＴコマンドで引き渡すデータ値
//    　　　value_len　　　＝ その長さ
//    戻り値：送信したAPIサービス長。送信しなかった場合は0

    char data_api[API_TXSIZE];
    byte i;
    byte len=0;             // APIサービス長
    byte check=0xFF;        // チェックサム
    byte data_position=5;   // 送信データdata_api[]の何処にvalue[]を入れるか
    byte ret=0;
    
    if( PACKET_ID == 0xFF ){
        PACKET_ID=0x01;
    }else{
        PACKET_ID++;
    }
    
    if(at[0] == 'T' && at[1] == 'X'){
        data_api[3]=(char)0x10;     // TXデータ送信モード
        data_api[4]=(char)0x00;     // フレームIDを使用しない(no responce)
        for( i=5 ; i<=12 ; i++)  data_api[i]=(char)ADR_DEST[i-5];
        for( i=13 ; i<=14 ; i++) data_api[i]=(char)SADR_DEST[i-13];
        data_api[15]=(char)0x00;    // ZigBeeホップ数
        data_api[16]=(char)0x00;    // 暗号化＝しない
        data_position=17;
        len=14;
    }                   // サービスデータにMD+FI+ADR(8)+SAD(2)+OPT(2)が入る
    
    if( len ){
        data_api[0]=(char)0x7E;             // デリミタ
        data_api[1]=(char)0x00;             // パケット長の上位(送らない前程)
        for( i=3 ; i < data_position ; i++) check -= (byte)data_api[i];
        if( value_len > 0 ){
            for( i=0 ; i<value_len; i++){
                data_api[data_position + i] = (char)value[i];
                check -= (byte)data_api[data_position + i];
                len++;
            }
        }
        data_api[2]    =(char)len;
        data_api[len+3]=(char)check;

        check = sci_write_check();      // 以降 checkはシリアルバッファ確認に使用する
        //シリアルデータ送信
        if(  check > 0 ){
            sci_write( data_api, (byte)(len+4) );
            ret=len+3;
        }else{
            ret=0;
        }
    }

    return( ret );
}*/

/*byte xbee_putstr( const char *s ){

//    処理：文字を送信する
//    入力：char *s
//    出力：送信データ長を応答。０の場合は異常
  
    byte data[API_TXSIZE-17];       // 17バイトはAPIヘッダ+CRC1バイトなのでデータ長は[API_TXSIZE-18]+null文字で+1する-17
    byte i;

    for(i=0; (i< (API_TXSIZE-18) ) && (s[i] != 0x00) ; i++){    // データ長はAPI_TXSIZE-18
        data[i] = (byte)s[i];       // テキストデータをバイナリデータ（バイト値）に変換する
    }
    data[i] = 0x00;
    if( xbee_at_tx( "TX", data , i) == 0) i=0;
    
    return( i );
}*/

/*byte xbee_uart(const byte *address, const char *in){

//    入力：byte *address = 宛先(子機)アドレス 
//    　　　char *in = 送信するテキスト文字。最大文字数はAPI_TXSIZE-1
//    出力：戻り値 = 送信パケット番号PACKET_ID。0x00は失敗。

    byte ret=0;

    xbee_address( address );                        // 宛先のアドレスを設定
    if( xbee_putstr( in ) > 0 ) ret = PACKET_ID;

    return( ret );
}*/



void to_rad(double myLat, double myLong, double Latitude, double Longitude){ //緯度経度をradに変換
    double myLat_deg = floor(myLat / 100.0) ;
           myLat_rad = (myLat_deg + (myLat - (myLat_deg * 100.0)) / 60.0) * (PI / 180.0) ;                  //自機の緯度をradに変換
    double myLong_deg = floor(myLong / 100.0) ;
           myLong_rad = (myLong_deg + (myLong - (myLong_deg * 100.0)) / 60.0) * (PI / 180.0);               //自機の経度をradに変換
    double Latitude_deg = floor(Latitude / 100.0) ;
           Latitude_rad = (Latitude_deg + (Latitude - (Latitude_deg * 100.0)) / 60.0) * (PI / 180.0);       //他機の緯度をradに変換
    double Longitude_deg = floor(Longitude / 100.0) ;
           Longitude_rad = (Longitude_deg + (Longitude - (Longitude_deg * 100.0)) / 60.0) * (PI / 180.0);   //他機の経度をradに変換
}

double hubeni_distance(double lat1, double long1, double lat2, double long2){//ヒュベニの公式を用いて距離を求める。緯度経度はラジアン。
    double dx = long1 - long2;                                      //経度の差
    double dy = lat1 - lat2;                                        //緯度の差
    double uy = (lat1 + lat2) / 2.0;                                //緯度の平均
    double W = sqrt(1.0 - e2 * pow(sin(uy),2));                     //各曲率半径の分母
    double M = m / pow(W,3);                                        //子午線曲率半径
    double N = A / W;                                               //卯酉線曲率半径
    double d = sqrt(pow((dy * M),2) + pow((dx * N * cos(uy)),2));   //距離
    return d;
}

/*double directions(double lat1, double long1, double lat2, double long2){//自機から見た相手の方位を求める。緯度経度はラジアン。
    double dir = 90 - atan2(sin(long2-long1), cos(lat1) * tan(lat2) - sin(lat1) * cos(long2-long1));
    return dir;
}*/

double directions(double lat1, double long1, double lat2, double long2){//自機から見た相手の方位を求める。緯度経度はラジアン
    double dir_rad = atan2(cos(lat2) * sin(long2-long1), cos(lat1) * sin(lat2) - sin(lat1) * cos(lat2) * cos(long2 - long1));
    if(dir_rad < 0){
        dir_rad += (2.0 * PI);
    }
    double dir = dir_rad * (180.0 / PI);
    return dir;
}

double map(double x, double in_min, double in_max, double out_min, double out_max)//範囲変換
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

void SBUS(){
    while(sbus.readable() > 0){
        if(sbus.getc() == '~'){
            for(i = 0; i < 4; i++){
                for(k = 0; k < 6; k++){
                    sbus_from[i][k] = sbus.getc();
                    if(sbus_from[i][k] == ','){
                        sbus_from[i][k] = '\0';
                        channels_from[i] = atoi(sbus_from[i]);
                        break;
                    }
                }
            }
                
            channels_to[0] = channels_from[0];
            channels_to[1] = channels_from[1];
            channels_to[2] = channels_from[2];
            channels_to[3] = channels_from[3];
            //channels_to[4] = channels_from[4];
            //channels_to[5] = channels_from[5];
                    
            pc.printf("\n");
            pc.printf("%6d%6d%6d%6d",
                    channels_from[0],
                    channels_from[1],
                    channels_from[2],
                    channels_from[3]
            );
            if(through == 0){
                through = 1;
            }else if(through == 1){
                through = 0;
            }else;
        }
        //not_use = sbus.getc();
        sbus.getc();
    }
}

int main(){
    int n = 0;
    myled1 = true;
    myled2 = true;
    myled3 = true;
    request = false;
    
    sbus.baud(57600);
        
    pc.baud(9600);
    sGps.baud(9600);
    
    //_xbee_serial.baud(57600);
    //_xbee_serial.format(8, Serial::None, 1);
    //_xbee_serial.attach(&_xbee_serial_callback);
    xbee_init(0);
    
    imu.init(1,BITS_DLPF_CFG_188HZ);
    printf("Gyro_scale=%u\n",imu.set_gyro_scale(BITS_FS_1000DPS));
    wait(0.2);
    printf("Acc_scale=%u\n",imu.set_acc_scale(BITS_FS_8G));
    wait(0.2);
    imu.AK8963_calib_Magnetometer();
    wait(0.2);
    for(i = 0; i < 3; i++){
        offsetM[i] = (m_max[i] + m_min[i]) / 2.0;
        imu.AK8963_setoffset(i,offsetM[i]);
    }
    pc.printf("%10.3f,%10.3f,%10.3f\n\n\n"
                ,imu.Magnetometer_offset[0]
                ,imu.Magnetometer_offset[1]
                ,imu.Magnetometer_offset[2]
    );
    wait(0.2);
    
    //byte dev1[]={0x00,0x13,0xA2,0x00,0x40,0xAF,0x4F,0x4A};//1                   //高木さん設定
    byte dev2[]={0x00,0x13,0xA2,0x00,0x40,0xF9,0x87,0xC9};//2
    //byte dev3[]={0x00,0x13,0xA2,0x00,0x40,0xF9,0x88,0x91};//3
    
    //byte dev1[]={0x00,0x13,0xA2,0x00,0x40,0xCA,0x9A,0xE1};//1                   //change
    byte dev3[]={0x00,0x13,0xA2,0x00,0x40,0xCA,0x9A,0xC7};//2                 //菊池設定
    
    t.start();   //mbedのタイマーを開始する
    anglesT.start();
    t2.start();//mbedのタイマーを開始する(パソコンに各機のデータを送るときのタイムログ用)
    //sbus.attach(SBUS, Serial::RxIrq);
    imu.Timer_start();
    
    imu.AK8936_read_Orientation();
    heading0 = imu.getdata[0];
    myled2 = !myled2;
    heading_before = heading0;
    heading1 = heading0;
    heading2 = heading0;
    heading3 = heading0;
    heading4 = heading0;
    heading5 = heading0;
    
    while(1){
        if(n == 500){
            myled1 = !myled1;
            n = 0;
        }else{
            n++;
        }
        
        imu.AK8936_read_Orientation();
        
        char buf[10], s[70], s_to[40];
        
        byte discard, re;
        char a[5][13], b[5][13], c[13];
        
        /*imu.AK8936_read_Orientation();
        heading = imu.getdata[0];
        //heading0 = imu.getdata[0];
        myled2 = !myled2;
            
            //移動平均：方位センサのノイズを除去するために作成したコード(今ところ、うまく機能しないため使用していない)
            /*heading = (heading0 + heading1 + heading2 + heading3 + heading4 + heading5)/6;  //移動平均
            heading5 = heading4;
            heading4 = heading3;
            heading3 = heading2;
            heading2 = heading1;
            heading1 = heading0;*/
                    
            /*heading = (1 - s)*heading_before +s*heading;              //ローパスフィルタ
            heading_before = heading;*/    
        
            if(t.read_ms() > 100){
            
            imu.AK8936_read_Orientation();
            heading = imu.getdata[0];
            //heading0 = imu.getdata[0];
            myled2 = !myled2;
            
            
            /*heading = (heading0 + heading1 + heading2 + heading3 + heading4 + heading5)/6;  //移動平均
            heading5 = heading4;
            heading4 = heading3;
            heading3 = heading2;
            heading2 = heading1;
            heading1 = heading0;*/
                    
            /*heading = (1 - p)*heading_before +p*heading;              //ローパスフィルタ
            heading_before = heading;*/ 
            
            //sprintf(s,"%02d%f,\r",aa_,heading);//1
            //sprintf(s,"%02d%f,\r",bb_,heading);//2
            //sprintf(s,"%02d%f,\r",cc_,heading);//3
            
            //xbee_uart(dev1,s);  //by kikuchi
            //xbee_uart(dev2,s);
            //xbee_uart(dev3,s);
            
            //myled3 = !myled3;
            
             t.reset();
        }
        
        while(sGps.readable() > 0){
            if(sGps.getc() == '$'){
                for(i = 0; i < 5; i++){
                    buf[i] = sGps.getc();
                }
                if (0 == strncmp("GNRMC", buf, 5)) {
                    char dot = sGps.getc();
                    for(i = 0; i < 5; i++){
                        for(j = 0; j < 13; j++){
                            b[i][j] = sGps.getc();
                            if(b[i][j] == ','){
                                b[i][j] = '\0';
                                break;
                            }
                        }
                    }
                                    
                    Time = atof(b[0]);
                    Lat = atof(b[2]);
                    Long = atof(b[4]);
                    //marker_me = channels_to[5];
                    
                    imu.AK8936_read_Orientation();
                    heading = imu.getdata[0];
                    //heading0 = imu.getdata[0];
                    myled2 = !myled2;
                    
                    
                    /*heading = (heading0 + heading1 + heading2 + heading3 + heading4 + heading5)/6;  //移動平均
                    heading5 = heading4;
                    heading4 = heading3;
                    heading3 = heading2;
                    heading2 = heading1;
                    heading1 = heading0;*/
                    
                    /*heading = (1 - p)*heading_before +p*heading0;              //ローパスフィルタ
                    heading_before = heading;*/     
                                        
                    sprintf(s,"%02d%9.2f,%10.5f,%11.5f,%9.5f,\r\n",aa,Time,Lat,Long,heading);//1
                    //sprintf(s,"%02d%9.2f,%10.5f,%11.5f,%9.5f,%04d,\r",aa,Time,Lat,Long,heading,marker_me);//1
                                        
                    /*pc.printf("\n");                                            //モニター用
                    pc.printf("MY ");
                    pc.printf(s);*/
                    
                    //wait_us(1000);
                    xbee_uart(dev2,s);
                    //xbee_uart(dev3,s);
                    
                    t.reset();
                }
            }
        }
        
        while( xbee_readable() > 0 ){
        //while( xbee.readable() > 0 ){
            if(sci_read(1) == 0x7E){
            //if(xbee.getc() == 0x7E){
                wait_us(200);
                for(i = 0; i < 4; i++){
                    discard = sci_read(1);
                    //discard = xbee.getc();
                    wait_us(200);
                }
                for(;;){
                    discard = sci_read(1);
                    //discard = xbee.getc();
                    wait_us(200);
                    //if(discard == 49) break;
                    if(discard == 50) break;
                    //if(discard == 51) break;
                }
                re = sci_read(1);
                //re = xbee.getc();
                wait_us(200);
                if(re == 49){
                    char No[] = {discard, re};
                    int Noi = atoi(No);
                    
                    for(j = 0; j < 4; j++){
                        for(k = 0; k < 13; k++){
                            a[j][k] = sci_read(1);
                            //a[j][k] = xbee.getc();
                            wait_us(200);
                            if(a[j][k] == ','){
                                a[j][k] = '\0';
                                break;
                            }
                        }
                    }
                    
                    /*for(j = 0; j < 5; j++){
                        for(k = 0; k < 13; k++){
                            a[j][k] = sci_read(1);
                            //a[j][k] = xbee.getc();
                            wait_us(200);
                            if(a[j][k] == ','){
                                a[j][k] = '\0';
                                break;
                            }
                        }
                    }*/
                
                    Timef = atof(a[0]);
                    Latf = atof(a[1]);
                    Longf = atof(a[2]);
                    Heading = atof(a[3]);
                    //marker = atoi(a[4]);
                    
                    /*pc.printf("\n");
                    if(Noi == 11){
                        pc.printf("A  ");
                    }else if(Noi == 21){
                        pc.printf("B  ");
                    }else if(Noi == 31){
                        pc.printf("C  ");
                    }else{
                        pc.printf("%d ",Noi);
                    }*/
                
                    /*//pc.printf("Time = ");                                     //モニター用
                    pc.printf("%f",Timef);
                    //pc.printf(Time);
                    pc.printf(" : ");
                    //pc.printf("Latitude = ");
                    pc.printf("%f",Latf);
                    //pc.printf(Lat);
                    pc.printf(" : ");
                    //pc.printf("Longitude = ");
                    pc.printf("%f",Longf);
                    //pc.printf(Long);
                    pc.printf(" : ");*/
                    /*pc.printf("Heading = ");
                    pc.printf("%f",Heading);*/
                    //pc.printf(" : ");
                    //pc.printf("Marker = ");
                    //pc.printf("%d",marker);
                    
                    
                    /*char dis[40];                                             //モニター用
                    sprintf(dis,"dis=%5.2f,b_head=%9.5f\r\n",distance,b_head);
                    printf(dis);*/
                    
                }
                if(re == 50){
                    char No[] = {discard, re};
                    int Noi = atoi(No);
                    
                    for(j = 0; j < 13; j++){
                        c[j] = sci_read(1);
                        //c[j] = xbee.getc();
                        wait_us(200);
                        if(c[j] == ','){
                            c[j] = '\0';
                            break;
                        }
                    }
                    
                    Heading = atof(c);
                
                    /*pc.printf("\n");
                    if(Noi == 12){
                        pc.printf("A  ");
                    }else if(Noi == 22){
                        pc.printf("B  ");
                    }else if(Noi == 32){
                        pc.printf("C  ");
                    }else{
                        pc.printf("%d ",Noi);
                    }
                    
                    pc.printf("%f",Heading);*/
                }
            }
            //pc.printf("f");
        }
        
        if(input_before != signal && signal == true){
            channels_to[5] = 1541;
            input_before = signal;
            pc.printf("%d\n",channels_to[5]);
        }else if(input_before != signal && signal == false){
            channels_to[5] = 1024;
            input_before = signal;
            pc.printf("%d\n",channels_to[5]);
        }else;
        
        //if((Lat_before != Lat) && (Latf_before != Latf)){
              if((Lat != 0.0) && (Latf != 0.0) && (Long != 0.0) && (Longf != 0.0)){
                Lat_before = Lat;
                Latf_before = Latf;
                Long_before = Long;
                Longf_before = Longf;
                to_rad(Lat, Long, Latf, Longf);
                distance = hubeni_distance(myLat_rad, myLong_rad, Latitude_rad, Longitude_rad);
                direction = directions(myLat_rad, myLong_rad, Latitude_rad, Longitude_rad);
                
                /*char dis[40];
                sprintf(dis,"dis=%5.2f,b_head=%9.5f\r\n",distance,b_head);
                printf(dis);*/
            
            }else{
                if(distance != -2.0){
                    //distance = -1.0;
                    ail = 1024;
                    ele = 1024;
                    rud = 1024;
                    sprintf(s_to,"~%04d,%04d,%04d,%04d,%04d,%04d,",
                                ail,
                                ele,
                                channels_to[2],
                                rud,
                                channels_to[4],
                                channels_to[5]
                    );
                    sbus.printf(s_to);
                    //pc.printf("\n");
                    //pc.printf(s_to);
            
                    //char sta[40];
                    //sprintf(sta,"F:Time=%.2f, ail=%d, ele=%d\r",Time,ail,ele);
                    //pc.printf(sta);
                    //xbee_uart(dev3,sta);
                    //xbee_send_frame(dev3, sta, sizeof(sta));
            
                    distance = -2.0;
                }
            }
        //}
        
            Heading_before = Heading;
            
            imu.AK8936_read_Orientation();
            heading = imu.getdata[0];
            //heading0 = imu.getdata[0];
            myled2 = !myled2;
                
            
            /*heading = (heading0 + heading1 + heading2 + heading3 + heading4 + heading5)/6;  //移動平均
            heading5 = heading4;
            heading4 = heading3;
            heading3 = heading2;
            heading2 = heading1;
            heading1 = heading0;*/
                    
            /*heading = (1 - p)*heading_before +p*heading0;              //ローパスフィルタ
            heading_before = heading;*/     
            
            /*b_head_front = Heading + (180.0 - heading); //先導機と方位を揃える
            if(b_head_front > 360.0){
                b_head_front = b_head_front - 360.0;
            }else if(b_head_front < 0.0){
                b_head_front = b_head_front + 360.0;
            }else;
            
            if(b_head_front >= 180.0){
                rud = map(b_head_front,180.0,360.0,1084,1384);
            }else{
                rud = map(b_head_front,180.0,0.0,963,664);
            }*/
            
            b_head_front = Heading + (180.0 - heading);                         //interaction mode:dir control           
            b_head_front = b_head_front / 2;
                                     
            if(b_head_front > 180.0){
                b_head_front = b_head_front - 180.0;
            }else if(b_head_front < 0.0){
                b_head_front = b_head_front + 180.0;
            }else;
            
            if(b_head_front >= 90.0){
                rud = map(b_head_front,90.0,180.0,1084,1200);                   //change
            }else{
                rud = map(b_head_front,90.0,0.0,963,848);
            }
            
            /*if(b_head_front >= 90.0){
                rud = map(b_head_front,90.0,180.0,1084,1284);
            }else{
                rud = map(b_head_front,90.0,0.0,963,764);
            }*/  
                        
            b_head = direction + (180.0 - heading); //先導機に追従
            if(b_head > 360.0){
                b_head = b_head - 360.0;
            }else if(b_head < 0.0){
                b_head = b_head + 360.0;  
            }else 
            
            if(0 <= distance && distance <= 10.0 ){//---------------------------------------------反発制御
                                                                                                                
            range = map(distance,0.0,10.0,450.0,150.0);                           //距離値 → 制御値 範囲変換 ( 距離1～距離2 → 制御値1～制御値2 )
            
            if(b_head >= 0.0 && b_head < 90.0){                                 //親機の方向ごとの反発制御値
                ele = 1024 + (range * cos(map(b_head,0.0,90.0,0.0,(PI/2.0))));   //elevetor = ニュートラル値 + ( 制御量 × （0~90°のcos値) )
                ail = 1024 + ((range*1) * sin(map(b_head,0.0,90.0,0.0,(PI/2.0))));  // aileron = ニュートラル値 + ( 制御量 × （0~90°のsin値) )
            }else if(b_head >= 90.0 && b_head < 180.0){
                ele = 1024 - (range * sin(map(b_head,90.0,180.0,0.0,(PI/2.0))));
                ail = 1024 + ((range*1) * cos(map(b_head,90.0,180.0,0.0,(PI/2.0))));
            }else if(b_head >= 180.0 && b_head < 270.0){
                ele = 1024 - (range * cos(map(b_head,180.0,270.0,0.0,(PI/2.0))));
                ail = 1024 - (range * sin(map(b_head,180.0,270.0,0.0,(PI/2.0))));      
            }else{
                ele = 1024 + (range * sin(map(b_head,270.0,360.0,0.0,(PI/2.0))));
                ail = 1024 - (range * cos(map(b_head,270.0,360.0,0.0,(PI/2.0))));
            } //操舵の出力を平滑化し、制御領域の境界で滑らかに制御の切り替えを行えるようにするために追加した
              //ただ、有効性は確かではないので、境界での動きが気になるときには試すと良い
                
                /*ele = (1 - q)*ele_before + q*ele;            //ローパスフィルタ change
                ele_before = ele; 
                ail = (1 - q)*ail_before + q*ail;              //ローパスフィルタ
                ail_before = ail;*/
            
                ele = 1024;
                ail = 1024;
                //rud = 1024;
            
            char sta[60];
            //sprintf(sta,"Red=%-4.1f,h=%-5.1f,a=%4d,e=%4d\r\n",distance,b_head,ail,ele);            
            //sprintf(sta,"Red=%-d,D=%-4.1f,h=%-5.1f,a=%4d,e=%4d\r\n",t2.read_ms(),distance,b_head,ail,ele);
            sprintf(sta,"Red=%-d,h=%-5.1f,r=%4d\r\n",t2.read_ms(),heading,rud);
            //sprintf(sta,"Red=%-7.1f,D=%-4.1f,h=%-5.1f,a=%4d,e=%4d\r\n",Time,distance,b_head,ail,ele);
            //xbee_uart(dev3,sta);
            
            ++count;                                                          //実行回数のうち何回pcのxbeeに送るかを決めるプログラム
            if(count%h == 0) {
                xbee_uart(dev3,sta);
                }
            
            }else if(distance > 50.0){ //--------------------------------------接近制御
            //if(distance > 10.0){
                
            range = map(distance,20.0,70.0,200.0,800.0);
                        
            if(b_head >= 0.0 && b_head < 90.0){
                ele = 1024 - (range * cos(map(b_head,0.0,90.0,0.0,(PI/2.0))));
                ail = 1024 - (range * sin(map(b_head,0.0,90.0,0.0,(PI/2.0))));
            }else if(b_head >= 90.0 && b_head < 180.0){
                ele = 1024 + (range * sin(map(b_head,90.0,180.0,0.0,(PI/2.0))));
                ail = 1024 - (range * cos(map(b_head,90.0,180.0,0.0,(PI/2.0))));
            }else if(b_head >= 180.0 && b_head < 270.0){
                ele = 1024 + (range * cos(map(b_head,180.0,270.0,0.0,(PI/2.0))));
                ail = 1024 + ((range*1) * sin(map(b_head,180.0,270.0,0.0,(PI/2.0))));
            }else{
                ele = 1024 - (range * sin(map(b_head,270.0,360.0,0.0,(PI/2.0))));
                ail = 1024 + ((range*1) * cos(map(b_head,270.0,360.0,0.0,(PI/2.0))));
            }
            
            /*ele = (1 - p)*ele_before + p*ele;              //ローパスフィルタ change
            ele_before = ele; 
            ail = (1 - p)*ail_before + p*ail;              //ローパスフィルタ
            ail_before = ail;*/
            
            ele = 1024;                                                         //direction only
            ail = 1024;
            //rud = 1024;
            
            char sta[60];
            //sprintf(sta,"Red=%-4.1f,h=%-5.1f,a=%4d,e=%4d\r\n",distance,b_head,ail,ele);            
            //sprintf(sta,"Red=%-d,D=%-4.1f,h=%-5.1f,a=%4d,e=%4d\r\n",t2.read_ms(),distance,b_head,ail,ele);
            sprintf(sta,"Red=%-d,h=%-5.1f,r=%4d\r\n",t2.read_ms(),heading,rud);
            //sprintf(sta,"Red=%-7.1f,D=%-4.1f,h=%-5.1f,a=%4d,e=%4d\r\n",Time,distance,b_head,ail,ele);
            //sprintf(sta,"Red=%-7.1f,Dis=%-4.1f,head=%-5.1f,ail=%4d,ele=%4d\r\n",Time,distance,heading,ail,ele);
            //xbee_uart(dev3,sta);
            
            ++count;                                                        //counter
            if(count%h == 0) {
                xbee_uart(dev3,sta);
                }                                                
                                                                                
            }else if(10.0 < distance && distance <= 50.0){                       //平行移動制御
            
                    //↓waypointの指定
                    
                    /*to_Lat   = 3521.70246;                                      //way point takama 2020/11/30
                    to_Long  = 13916.74538;*/
                    /*to_Lat   = 3521.87999;                                      //way point shibahu 2020/11/16
                    to_Long  = 13916.47731;*/
                    /*to_Lat   = 3521.70546;                                      //way point takama 2021/2/10
                    to_Long  = 13916.74720;*/                                         
                    to_Lat   = 3521.70265;                                      //way point takama 2020/10/21
                    to_Long  = 13916.74652;
                    to_rad(Lat, Long, to_Lat, to_Long);
                    wp_distance = hubeni_distance(myLat_rad, myLong_rad, Latitude_rad, Longitude_rad);
                    wp_direction = directions(myLat_rad, myLong_rad, Latitude_rad, Longitude_rad);
                    
                    wp_head = wp_direction + (180.0 - heading);                     //wp_head : 自機とW.Pの方位角θ₂
                    if(wp_head > 360.0){
                        wp_head = wp_head - 360.0;
                    }else if(wp_head < 0.0){
                        wp_head = wp_head + 360.0;  
                    }else ;
                                        
                    
                    range = map(wp_distance,0.0,100.0,0.0,1200.0);
                        
                if(wp_head >= 0.0 && wp_head < 90.0){
                    ele = 1024 - (range * cos(map(wp_head,0.0,90.0,0.0,(PI/2.0))));
                    ail = 1024 - (range * sin(map(wp_head,0.0,90.0,0.0,(PI/2.0))));
                }else if(wp_head >= 90.0 && wp_head < 180.0){
                    ele = 1024 + (range * sin(map(wp_head,90.0,180.0,0.0,(PI/2.0))));
                    ail = 1024 - (range * cos(map(wp_head,90.0,180.0,0.0,(PI/2.0))));
                }else if(wp_head >= 180.0 && wp_head < 270.0){
                    ele = 1024 + (range * cos(map(wp_head,180.0,270.0,0.0,(PI/2.0))));
                    ail = 1024 + (range * sin(map(wp_head,180.0,270.0,0.0,(PI/2.0))));
                }else{
                    ele = 1024 - (range * sin(map(wp_head,270.0,360.0,0.0,(PI/2.0))));
                    ail = 1024 + (range * cos(map(wp_head,270.0,360.0,0.0,(PI/2.0))));
                }
                
                /*ele = (1 - p)*ele_before + p*ele;              //ローパスフィルタ change
                ele_before = ele; 
                ail = (1 - p)*ail_before + p*ail;              //ローパスフィルタ
                ail_before = ail;*/
                
                ele = 1024;                                                         //direction only
                ail = 1024;
                //rud = 1024; 
                char sta[60];
                //sprintf(sta,"RedW=%-d,D=%-4.1f,h=%-5.1f,a=%4d,e=%4d\r\n",t2.read_ms(),distance,heading,ail,ele);
                sprintf(sta,"Red=%-d,h=%-5.1f,r=%4d\r\n",t2.read_ms(),heading,rud);
                //sprintf(sta,"Red=%-7.1f,D=%-4.1f,h=%-5.1f,a=%4d,e=%4d\r\n",Time,distance,b_head,ail,ele);
                //sprintf(sta,"Red=%-7.1f,Dis=%-4.1f,head=%-5.1f,ail=%4d,ele=%4d\r\n",Time,distance,heading,ail,ele);
                //sprintf(sta,"Red=%-7.1f,Dis=%-4.1f,wp_dis=%-4.1f,ail=%4d,ele=%4d\r\n",Time,distance,wp_distance,ail,ele);
                //sprintf(sta,"Red=%-7.1f,Dis=%-4.1f,wp_dis=%-4.1f,wp_head=%-5.1f,ail=%4d,ele=%4d\r\n",Time,distance,wp_distance,wp_head,ail,ele);
                //sprintf(sta,"Red=%-7.1f,Dis=%-4.1f,wp_dis=%-4.1f,head=%-5.1f,ail=%4d,ele=%4d\r\n",Time,distance,wp_distance,heading,ail,ele);
                //xbee_uart(dev3,sta);
                
                ++count;                                                        //counter
                if(count%h == 0) {
                   xbee_uart(dev3,sta);
                    }
                
                      
            }else{
                
                ele = 1024;                                                         //direction only
                ail = 1024;
                rud = 1024;
                
                char sta[60];
                //sprintf(sta,"Red=%-d,D=%-4.1f,h=%-5.1f,a=%4d,e=%4d\r\n",t2.read_ms(),distance,b_head,ail,ele);
                sprintf(sta,"Red=%-d,h=%-5.1f,r=%4d\r\n",t2.read_ms(),heading,rud);
                
                 ++count;                                                        //counter
                if(count%h == 0) {
                    xbee_uart(dev3,sta);
                    }
                
            } 
                     
            sprintf(s_to,"~%04d,%04d,%04d,%04d,%04d,%04d,",
                        ail,
                        ele,
                        channels_to[2],
                        rud,
                        channels_to[4],
                        channels_to[5]
            );
            
            sbus.printf(s_to);
            
            ++count;                                                            //ここでは実行回数のうち何回相手機に情報を送るかを決める箇所
            if(count%hh == 0) {                                                 //このプログラムのありなしで動作が変わるため、違いを確認して置いた方が良い 
                xbee_uart(dev2,s);
            }
            
        }               
    }
//}