#include "renderclass.h"
#include "mbed.h"
#include "laserProjectorHardware.h"
#include <vector>

Ticker translationTimer;

//for translating -----------------------------------------------------------------

inline void render::shearing(point2dl& dataBefore)
{
    dataBefore.x = dataBefore.x - speed * cos(angle+PI/2)*speedTimer.read_us()/400;
    dataBefore.y = dataBefore.y - speed * sin(angle+PI/2)*speedTimer.read_us()/400;
}

inline void render::rotation(point2dl& dataBefore)
{
    int x=dataBefore.x;
    dataBefore.x = 1800 * cos(angle) + sin(angle)*x - cos(angle)*dataBefore.y;
    dataBefore.y = 1800 * sin(angle) - cos(angle)*x - sin(angle)*dataBefore.y;
}
//----------------------------------------------------------------------------------

void render::startRender()
{
    speedTimer.start();
    renderTimer.attach_us(this, &render::draw,RENDER_INTERVAL);
    pc.printf("render started!\n");
}

void render::stopRender()
{
    renderTimer.detach();
    translated.clear();
    currentLetters=0;
    currentPoints=0;
}

void render::setRender(vector<letter> *p)
{
    ptext = p;
    pc.printf("Size of text to render: %d/n", (*ptext).size() );
    //for(int i=0; i!=(*ptext).size(); i++){
    for(std::vector<letter>::iterator itr = (*ptext).begin(); itr != (*ptext).end(); ++itr) {
        translated.push_back(*itr);
    }                                            //copy the liblary to the buffer.
    
    
    currentLetters=0;
    currentPoints=0;
    shearingSwitch = 1;

}


void render::updateSpeed(float gspeed, float gangle){
    speed = gspeed;
    angle = gangle;
    
    //speed=sqrt(vx*vx+vy*vy);//*factorSpeed;
    //angle=atan2(vy,vx);
}

int stopcounter=100;

void render::draw()
{
    if(translated.size()>0){
    if(stopcounter == 99) speedTimer.reset();
    if(stopcounter==100){
    
    point2dl drawPoint=translated[currentLetters].letpoints[currentPoints];
    transform(drawPoint); // transform it with the current speed and angle
    //IO.setRedPower(drawPoint.laserSwitch);
    IO.writeOutXY(CENTER_AD_MIRROR_X + (int)drawPoint.x , CENTER_AD_MIRROR_Y + (int)drawPoint.y);
    
    
    if(currentPoints>0) IO.setRedPower(translated[currentLetters].letpoints[currentPoints-1].laserSwitch);
    else                IO.setRedPower(0);             

    currentPoints++;
    }
    else stopcounter++;
    
    if(currentPoints >= translated[currentLetters].letpoints.size() ) {
        if(stopcounter == 100) stopcounter = 0;
        else if(stopcounter == 0){
        renderTimer.detach();
        }
        //wait_us(RENDER_INTERVAL);
        else if(stopcounter == 1){
        IO.setRedPower(0);
        //wait_us(RENDER_INTERVAL);
        currentLetters++;
        currentPoints = 0;
        renderTimer.attach_us(this, &render::draw,RENDER_INTERVAL);
        speedTimer.reset();
        }
    }
    if(currentLetters >= translated.size()) {
        currentLetters = 0;
        currentPoints = 0;
        renderTimer.detach();
        //wait_us(RENDER_INTERVAL);
        IO.setRedPower(0);
        //wait_us(RENDER_INTERVAL*200);
        renderTimer.attach_us(this, &render::draw,RENDER_INTERVAL);
        speedTimer.reset();
        stopcounter = -200;
    }
    }
}

void render::transform(point2dl& mypoint)
{
    rotation(mypoint);
    if(shearingSwitch == 1) shearing(mypoint);
}

