#include "mbed.h"
#include <string>
#include <vector>
#include "renderclass.h"
#include "laserProjectorHardware.h"

render myRender;

InterruptIn clockEncoderPin(p14);   //blue
DigitalIn directionPin(p15);    //green

void processSerial();
Timer timer_v;          // for shearing        //for send the speed on the serial port every 30 ms:
LocalFileSystem local("local");
//Serial pc(USBTX, USBRX);

unsigned int X, Y, T;
unsigned int beforeX , beforeY;
int startX = CENTER_AD_MIRROR_X;
int startY = CENTER_AD_MIRROR_Y;

float sint=0, cost=1;

float vx = 0, vy=0;
float theta=0, dt_betWords=50000, st=1800;
unsigned int dt=500, ticktime=600;

bool newPositionReady=false;
unsigned int counter=0;
vector<char> inputletters;

bool start=false;


//renderclass----------------------------------------------------------

vector<letter> alphabet;   // letter library
vector<letter> myText;

/*
string textString="H";

void createTextPoints(string& _str) {
    myText.clear();
    for (int i=0; i<_str.length(); i++) {
        myText.push_back(alphabet[(int)_str[i]-'a']);
    }
}
*/

////for culculate rotary velocity --------------------------------------------------------

volatile float angleIncrement = 2.0*PI / 1024; // when in Sign/Magnitude mode
float radious = 700, attachSecond = 10000;

// a ticker function to compute the speed periodically-------------------------------------------------------------
#define PERIODIC_COMPUTE 10000 // in us
volatile float angularSpeed = 0;
volatile float angle=0, oldAngle=0;
Ticker speedTimerCompute;
Ticker superEncoder;

// the external interrupt routine:
void encoderClock()
{
    if (directionPin) angle += angleIncrement ;
    else angle -= angleIncrement;
}

void computeSpeed()
{
    // We know exactly how much time passed since we last computed the speed, this is PERIODIC_COMPUTE in microseconds
    float oldspeed = angularSpeed;
    angularSpeed = ( 1000000.0 * (float)(angle-oldAngle) / (float)(PERIODIC_COMPUTE) + oldspeed )/ 2.0; // in rad/sec
    oldAngle=angle;
    myRender.updateSpeed(angularSpeed,angle);
    void processSerial();
}


int main()
{
    //read from TextFileLibrary ------------------------------------------------------
    FILE *fp = fopen("/local/text.txt", "r");
    if(!fp) {
        IO.setGreenPower(1);
        exit(1);
    }

    int letternum;
    fscanf(fp, "%d", &letternum);
    for(int i=0; i<letternum; i++) {
        letter bufl;
        fscanf(fp, "%d", &bufl.pointnum);
        for(int j=0; j<bufl.pointnum; j++) {
            point2dl bufp;
            fscanf(fp, "%d", &bufp.x);
            fscanf(fp, "%d", &bufp.y);
            fscanf(fp, "%d", &bufp.laserSwitch);
            bufl.letpoints.push_back(bufp);
        }
        alphabet.push_back(bufl);
    }


    // SETUP: --------------------------------------------------------------------------------------------
    IO.init(); // note: serial speed can be changed by checking in the hardwareIO.cpp initialization

    // initialize the angle (arbitrary origin):
    oldAngle=angle=0;

    // Attach the external interrupt routine----------------------------------------------------------------------
    superEncoder.attach_us(&encoderClock, 111);
    //clockEncoderPin.rise(&encoderClock);
    //clockEncoderPin.fall(&encoderClock);

    //using renderclass.cpp ----------------------------------------------------------
    //createTextPoints(textString);
    myRender.setRender(&myText);
    myRender.startRender();

    // Attach the periodic computing function:
    speedTimerCompute.attach_us(&computeSpeed, PERIODIC_COMPUTE);

    // Set displaying laser powers--------------------------------------------------------------------------
    IO.setRedPower(0);
    IO.setGreenPower(0);
    wait_ms(100);


    timer_v.start();
    // MAIN LOOP: --------------------------------------------------------------------------------------------
    while(1) {
        if (pc.readable()>0) processSerial();
    }
}

// --------------------------------------------------------------------------------------------
// String to store ALPHANUMERIC DATA (i.e., integers, floating point numbers, unsigned ints, etc represented as DEC) sent wirelessly:
    char stringData[24]; // note: an integer is two bytes long, represented with a maximum of 5 digits, but we may send floats or unsigned int...
    int indexStringData=0;//position of the byte in the string

    void processSerial() {
        start=true;
        while(pc.readable()>0) {

            char val =pc.getc();

            // Save ASCII numeric characters (ASCII 0 - 9) on stringData:
            if ((val >= '0') && (val <= '9')) { // this is 45 to 57 (included)
                stringData[indexStringData] = val;
                indexStringData++;
            } else if ((val >= 'a') && (val <= 'z')) { // this is 45 to 57 (included)
                myText.push_back(alphabet[val - 'a']);
                //inputletters.push_back(val);
            }

            else if (val == '/') {
                myRender.stopRender();
                myRender.setRender(&myText);
                myRender.startRender();
            } else if (val == '.') {
                myRender.stopRender();
                myText.clear();
                myRender.setRender(&myText);
                //inputletters.clear();
            }

            else if (val == 'X') {
                beforeX = X;
                stringData[indexStringData] = 0;
                X = atoi(stringData);
                indexStringData=0;
                vx = ((float)X-(float)beforeX) / (float)timer_v.read_us() *1000;
            }

            else if (val == 'Y') {
                beforeY = Y;
                stringData[indexStringData] = 0;
                Y = atoi(stringData);
                indexStringData=0;
                //timer_v.stop();
                //newSpeedReady = true;
                //if( (Y-beforeY) > 5){
                vy = ((float)Y-(float)beforeY) / (float)timer_v.read_us() *1000;
                
                myRender.updateSpeed(vx, vy);
                
               
            }

            else if (val == 'D') {
                stringData[indexStringData] = 0;
                dt = atoi(stringData);
                indexStringData=0;
                //makeBuffer();
            } else if (val == 'B') {
                stringData[indexStringData] = 0;
                dt_betWords = atoi(stringData);
                indexStringData=0;
                //makeBuffer();
            } else if (val == 'S') {
                stringData[indexStringData] = 0;
                myRender.shearingSwitch = 1 - myRender.shearingSwitch;
                pc.printf("shearingSwitch : %d \n" , myRender.shearingSwitch);
                indexStringData=0;
                //makeBuffer();
            } else if (val == 'R') {
                stringData[indexStringData] = 0;
                radious = atoi(stringData);
                indexStringData=0;
                //makeBuffer();
            } else if (val == 'T') {
                stringData[indexStringData] = 0;
                attachSecond = atoi(stringData);
                pc.printf("attachSecond : %d \n" , attachSecond);
                indexStringData=0;
                //makeBuffer();
            }
            // X value?
            /*else if (val=='x') {
                stringData[indexStringData] = 0 ;
                omegaX=atoi(stringData);
                indexStringData=0;
                //newPositionReady=true;
            }
            // Y value?
            else if (val=='y') {
                stringData[indexStringData] = 0 ;
                omegaY=atoi(stringData);
                indexStringData=0;
                makeBuffer();
                newPositionReady=true;
            }

            else if (val=='g') {
                stringData[indexStringData] = 0 ;
                int power=atoi(stringData);
                indexStringData=0;
                IO.setGreenPower(power);
            } else if (val=='r') {
                stringData[indexStringData] = 0 ;
                int power=atoi(stringData);
                indexStringData=0;
                IO.setRedPower(power);
            } else if (val=='c') {
                stringData[indexStringData] = 0 ;
                int power=atoi(stringData);
                indexStringData=0;
                IO.setRGBPower(power);
            }
            */

        }
    }