#include "mbed.h"
#include <vector>
#define PI 3.14159

#define RENDER_INTERVAL 700// in microseconds

struct point2dl {
    int x,y;
    int laserSwitch;   // laser {1: on 0:off} until next step
};

struct letter {
    int pointnum;
    vector<point2dl> letpoints;
};

class render{
    public:
    void startRender();
    void setRender(vector<letter> *p);
    void translating(float speed, float angle);
    void stopRender();
    void draw();
    void transform(point2dl& mypoint);
    void shearing(point2dl& dataBefore);
    void rotation(point2dl& dataBefore);
    void updateSpeed(float vx, float vy);

    int shearingSwitch;
    
    private:
    vector<letter> *ptext;
    vector<letter> translated;
    int currentLetters;
    int currentPoints;
    point2dl drawPoint;
    
    Ticker renderTimer;
    Timer   speedTimer;
    
    float speed;
    float angle;
    
};