
#ifndef hardwareIO_h
#define hardwareIO_h

#include "mbed.h"


//SPI library (for ADC chip) uses the following pins, but we don't have to set them and inputs or outputs 
// (this is done when the library is initialized, which is done by pre-instantiation:
#define SCK_PIN   p7 //SPI Clock
#define MISO_PIN  p6 //SPI input (data comming from DAC, here not connected) 
#define MOSI_PIN  p5 //SPI output (data going to DAC)

//**** CHIP SELECT pins for MP4922 DAC (mirrors and red laser)
// VERY IMPORTANT: the chip select for the DACs should be different from the default SPI "SS" pin (Slave Select), which is 53 by default (and will be used by the Ethernet Shield). 
#define CS_DAC_MIRRORS   p8 //Chip Select of the first DAC (mirrors)

//**** LASERS pins:
#define LASER_RED_PIN   p28 // NOT YET USED (TTL control). NOTE: this is NOT the locking sensing laser!
#define LASER_GREEN_PIN p29 // USED (TTL control)
#define LASER_BLUE_PIN  p30 // USED (TTL control)

//**** MIRRORS: 
//The DAC is 12 bytes capable (Max=4096), but we will limit this a little. 
#define MAX_AD_MIRRORS 4095 // note: 4095 is the absolute maximum for the SPI voltage (5V). This is for checking hardware compliance, but max and min angles can be defined for X and Y in each LivingSpot instance.
#define MIN_AD_MIRRORS 0  // note: 0 is 0 volts for the SPI voltage. 
// We assume that the center of the mirror is at MAX_AD_MIRRORS/2 = 2000:
#define CENTER_AD_MIRROR_X 2047 // This MUST BE the direction of the photodetector. 
#define CENTER_AD_MIRROR_Y 2047 // This MUST BE the direction of the photodetector.


extern  DigitalOut Laser_Red, Laser_Green, Laser_Blue;

// ==================================================================================================================================================================

class HardwareIO {
public:


    void init(void);

    void showLimitsMirrors( int times );

    // SPI control for DAC for mirrors and red laser power (low level): 
    void writeOutX(unsigned short value);
    void writeOutY(unsigned short value);
    void writeOutXY(unsigned short valueX, unsigned short valueY) {writeOutX(valueX); writeOutY(valueY);};
 
     
    //Displaying lasers: 
    // Again: for the moment laser are TTL but these could be analog. Now, it is just: powerValue > 0 ==> 'true'; else 'false'
    // Red laser:
    void setRedPower(int powerRed);
    // Green laser: 
    void setGreenPower(int powerGreen);
    // Blue laser: 
    void setBluePower(int powerBlue);
    // Setting all colors at once: 
    void setRGBPower(unsigned char color); // we will use the 3 LSB bits to set each color
    

    
private:

};


extern HardwareIO IO; // allows the object IO to be used in other .cpp files (IO is pre-instantiated in hardwareIO.cpp)
// NOTE: IO encapsulates many IO functions, but perhaps it is better not to have an IO object - just use each IO function separatedly (as with pc object for instance)
extern Serial pc; // allows pc to be manipulated by other .cpp files, even if pc is defined in the hardwareIO.cpp


#endif
