#ifndef _MMA7361_H_20150129_1716_
#define _MMA7361_H_20150129_1716_

#define def         -1
#define x_axis       0
#define y_axis       1
#define z_axis       2
#define A00          31356
#define A10          34040
#define A20          28639
#define A01          32717
#define A11          33388
#define A21          31475
#define G00          15633
#define G10          15797
#define G20          15187
#define G01          5416
#define G11          3220
#define G21          7131
#define PI           3.1415926535
#define THHO         0.0000000001

/** This progrum is to be easy to control MMA7361 analog sensor\n
 * site http://akizukidenshi.com/catalog/g/gM-06725/
 */
class mma7361{
private:
    AnalogIn dx;
    AnalogIn dy;
    AnalogIn dz;
    DigitalOut ST;
    DigitalOut GS;
    Serial pcdev;
    int range; //0 : 1.5G  1 : 6.0G
    int mat[4][3];
public:
    
    /** constracta
     * 
     * set all pin number
     * @param accelx analog pin which conect to x-axis (default = PA_0)
     * @param accely analog pin which conect to y-axis (default = PA_1)
     * @param accelz analog pin which conect to z-axis (default = PA_4)
     * @param set digital pin which conect to ST (default = PH_0)
     * @param set_range digital pin which conect to GS (default = PH_1)
     */
    mma7361(PinName accelx = PA_0,PinName accely = PA_1,PinName accelz = PA_4,PinName set = PH_0,PinName set_range = PH_1);
    
    /** function
     *
     * do the calibration, you need to conect terminal (ex.TeraTerm) by USB\n
     * the serial port is set in this class, but it's private\n
     * please follow the sentence on the terminal\n
     * this function set the matrix which use to calculate the gravity\n
     * if you don't want to do this or know the data, you can use set_each_num() or set_num() to set matrix
     */
    void calibration();
    
    /** function
     *
     * this function set the matrix which use to calculate the gravity and the range of sensitivity\n
     * the matrix's paramater is this\n
     * | A00 A10 A20 | : middle bits (=0G) of each axes when range is 1.5G\n
     * | A01 A11 A21 | : middle bits (=0G) of each axes when range is 6.0G\n
     * | G00 G10 G20 | : bits/G of each axes when range is 1.5G\n
     * | G01 G11 G21 | : bits/G of each axes when range is 6.0G
     * @param ax_0_0 A00 in the matrix (=-1:use default = 31356)
     * @param ay_0_0 A10 in the matrix (=-1:use default = 34040)
     * @param az_0_0 A20 in the matrix (=-1:use default = 28639)
     * @param ax_1_0 A01 in the matrix (=-1:use default = 32717)
     * @param ay_1_0 A11 in the matrix (=-1:use default = 33388)
     * @param az_1_0 A21 in the matrix (=-1:use default = 31475)
     * @param gx_0_0 G00 in the matrix (=-1:use default = 15633)
     * @param gy_0_0 G10 in the matrix (=-1:use default = 15797)
     * @param gz_0_0 G20 in the matrix (=-1:use default = 15187)
     * @param gx_1_0 G01 in the matrix (=-1:use default = 5416)
     * @param gy_1_0 G11 in the matrix (=-1:use default = 3220)
     * @param gz_1_0 G21 in the matrix (=-1:use default = 7131)
     * @param new_range range of sensitivity (0:1.5G 1:6.0G default = 0)
     */
    void set_each_num(int ax_0_0,int ay_0_0,int az_0_0,int ax_1_0,int ay_1_0,int az_1_0,int gx_0_0,int gy_0_0,int gz_0_0,int gx_1_0,int gy_1_0,int gz_1_0,int new_range = 0);
    
    /** function
     *
     * this function set the matrix which use to calculate the gravity and the range of sensitivity\n
     * the matrix's paramater is this\n
     * | A00 A10 A20 | : middle bits (=0G) of each axes when range is 1.5G\n
     * | A01 A11 A21 | : middle bits (=0G) of each axes when range is 6.0G\n
     * | G00 G10 G20 | : bits/G of each axes when range is 1.5G\n
     * | G01 G11 G21 | : bits/G of each axes when range is 6.0G
     * @param new_mat this matrix means {{A00,A10,A20},{A01,A11,A21},{G00,G10,G20},{G01,G11,G21}}, if elements have the value of -1 then it's value is default
     * @param new_range range of sensitivity (0:1.5G 1:6.0G default = 0)
     */
    void set_num(int (*new_mat)[3],int new_range = 0);
    
    /** function
     *
     * this function set the range of sensitivity
     * @param new_range range of sensitivity (0:1.5G 1:6.0G default = 0)
     */
    void set_range(int new_range = 0);
    
    /** function
     *
     * this function set the matrix to default
     */
    void clear_mat();
    
    /** function
     *
     * this function read the bit data (the result of ADC) of axis (x:x_axis y:y_axis z:z_axis)
     * @param axis select what you want to read (x:x_axis y:y_axis z:z_axis)
     * @return same as Analog class' read_u16()
     */
    int read_bit(int axis);
    
    /** function
     *
     * this function read the bit data (the result of ADC) and remove the effect of the gravity of axis (x:x_axis y:y_axis z:z_axis)
     * @param axis select what you want to read (x:x_axis y:y_axis z:z_axis)
     * @return do Analog class' read_u16() and remove the effect of gravity, data is from matrix
     */
    int read_bit_0(int axis);
    
    /** function
     *
     * this function read the acceleration by G
     * @param axis select what you want to read (x:x_axis y:y_axis z:z_axis)
     * @return the acceleration by G
     */
    float read_by_g(int axis);
    
    /** function
     *
     * this function do the low pass filter by program\n
     * this filter use the last bit data and get new bit data when this function is done\n
     * so when you use this, do loop if you want to use data from LPF\n
     * before you use this function, you should use set_1st_bit() to be short the time which the data be convergence\n
     * if you don't use set_1st_bit(), you must through about 300 data
     * @param int_bit the pointer of the variable which has acceleration
     * @param axis select what you want to do (x:x_axis y:y_axis z:z_axis)
     */
    void low_pass_filter(int *int_bit,int axis);
    
    /** function
     *
     * show the matrix on terminal
     */
    void show_mat();
    
    /** function
     *
     * change the acceleration data from bit to G
     * @param bit original bit data
     * @param axis select what you want to change (x:x_axis y:y_axis z:z_axis)
     * @return the acceleration by G
     */
    float bit_to_g(int bit,int axis);
    
    /** function
     *
     * use before low_pass_filter()\n
     * set direction_G to the unti direction of gravity from -1 to be short the time which the data be convergence\n
     * read the description of low_pass_filter()
     * @param variable the pointer of the variable which will have acceleration
     * @param axis select what you want to do (x:x_axis y:y_axis z:z_axis)
     * @param direction_G the unti direction of gravity from -1 to be short the time which the data be convergence (no need to be set completely)
     */
    void set_1st_bit(int *variable,int axis,float direction_G);
    
    /** function
     *
     * calculate the rotation acceleration from a_axis to b_axis\n
     * if the acceleration is smoller than THHO (0.01G), then the acceleration is 0G
     * @param a_value the pointer of the variable which will have acceleration
     * @param a_axis select what you want to do (x:x_axis y:y_axis z:z_axis)
     * @param b_value the pointer of the variable which will have acceleration
     * @param b_axis select what you want to do (x:x_axis y:y_axis z:z_axis)
     * @return the rotation acceleration by radian
     */
    float rotate(int *a_value,int a_axis,int *b_value,int b_axis);
    
    /** function
     *
     * change the radian to degree
     * @param rad radian which you want to change
     * @return return changed degree
     */
    float rad_to_deg(float rad);
};

#endif