#ifndef _L3GD20_H_20150124_1526_
#define _L3GD20_H_20150124_1526_

#include "binary.h"

#define WHO_AM_I         0x0F
#define CTRL_REG1        0x20
#define CTRL_REG2        0x21
#define CTRL_REG3        0x22
#define CTRL_REG4        0x23
#define CTRL_REG5        0x24
#define REFERENCE        0x25
#define OUT_TEMP         0x26
#define STATUS_REG       0x27
#define OUT_X_L          0x28
#define OUT_X_H          0x29
#define OUT_Y_L          0x2A
#define OUT_Y_H          0x2B
#define OUT_Z_L          0x2C
#define OUT_Z_H          0x2D
#define FIFO_CTRL_REG    0x2E
#define FIFO_SRC_REG     0x2F
#define INT1_CFG         0x30
#define INT1_SRC         0x31
#define INT1_TSH_XH      0x32
#define INT1_TSH_XL      0x33
#define INT1_TSH_YH      0x34
#define INT1_TSH_YL      0x35
#define INT1_TSH_ZH      0x36
#define INT1_TSH_ZL      0x37
#define INT1_DURATION    0x38
#define READ             0x80
#define WRITE            0x00
#define X                0
#define Y                2
#define Z                4

/** This progrum is to be easy to control L3GD20 sensor\n
 * site http://akizukidenshi.com/catalog/g/gK-06779/
 */
class l3gd20{
private:
    SPI l3gdev;
    DigitalOut l3gcs;
    Serial pcdev;
    int scale;
public:
    /** constracta
     * 
     * use default parm, mosi,miso,sck,cs is set to PB_15-PB_12\n
     * SPI frequency:1Mhz\n
     * SPI mode:3
     */
    l3gd20();
    
    /** constracta
     *
     * only set frequency parm\n
     * mosi,miso,sck,cs is set to PB_15-PB_12\n
     * SPI mode:3
     * @param fhz SPI frequency
     */
    l3gd20(int fhz);
    
    /** constracta
     *
     * mosi,miso,sck is set to PB_15-PB_13\n
     * SPI mode:3
     * @param cs SPI's cs pin
     * @param fhz SPI frequency
     */
    l3gd20(PinName cs,int fhz);
    
    /** constracta
     *
     * set all param, you can ellipsis SPI's mode
     * @param miso SPI's miso pin
     * @param mosi SPI's mosi pin
     * @param sck SPI's sck pin
     * @param cs SPI's cs pin
     * @param fhz SPI frequency
     * @param mode SPI's mode (default = 3)
     */
    l3gd20(PinName miso,PinName mosi,PinName sck,PinName cs,int fhz,int mode = 3);
    
    /** function
     *
     * reset all register
     * @return register number which return error (int)
     */
    int reg_reset();
    
    /** function
     *
     * send WHO_AM_I and return result
     * @return 1:error 0:no error (int)
     */
    int conect();
    
    /** function
     *
     * read 8bit register which set
     * @param reg register number of what you want
     * @return result (uint8_t)
     */
    uint8_t read_8(uint8_t reg);
    
    /** function
     *
     * read 16bit register which set
     * @param reg register number of what you want
     * @return result (uint8_t)
     */
    uint16_t read_16(uint8_t reg);
    
    /** function
     *
     * write 8bit to the register and check the register is realy set
     * @param reg register number of what you want to write
     * @param data register data what you want to write
     * @return result 1:error 0:no error
     */
    int write_8(uint8_t reg,uint8_t data);
    
    /** function
     *
     * only write 8bit to the register
     * @param reg register number of what you want to write
     * @param data register data what you want to write
     */
    void s_write_8(uint8_t reg,uint8_t data);
    
    /** function
     *
     * write 16bit to the register and check the register is realy set
     * @param reg register number of what you want to write
     * @param data register data what you want to write
     * @return result 1:error 0:no error
     */
    int write_16(uint8_t reg,uint16_t data);
    
    /** function
     *
     * now writing
     */
    int get_scale();
    
    /** function
     *
     * now writing
     */
    int set_scale(int dps);
    
    /** function
     *
     * now writing
     */
    int get_temp();
    
    /** function
     *
     * now writing
     */
    int16_t get_rotate_by_bit(int axis);
    
    /** function
     *
     * now writing
     */
    float get_rotate_by_rad(int axis);
    
    /** function
     *
     * now writing
     */
    float get_rotate(int axis);
    
    /** function
     *
     * now writing
     */
    float deg_to_rad(float deg);
};

#endif