#include "mbed.h"
#include "l3gd20.h"

/*---------------------------------constracta------------------------------------------*/

l3gd20::l3gd20(): l3gdev(PB_15,PB_14,PB_13),l3gcs(PB_12),pcdev(USBTX,USBRX)
{
    l3gdev.frequency(1000000);
    l3gdev.format(8,3);
}

l3gd20::l3gd20(int fhz): l3gdev(PB_15,PB_14,PB_13),l3gcs(PB_12),pcdev(USBTX,USBRX)
{
    l3gdev.frequency(fhz);
    l3gdev.format(8,3);
}

l3gd20::l3gd20(PinName cs,int fhz): l3gdev(PB_15,PB_14,PB_13),l3gcs(cs),pcdev(USBTX,USBRX)
{
    l3gdev.frequency(fhz);
    l3gdev.format(8,3);
}

l3gd20::l3gd20(PinName mosi,PinName miso,PinName sck,PinName cs,int fhz,int mode): l3gdev(mosi,miso,sck),l3gcs(cs),pcdev(USBTX,USBRX)
{
    l3gdev.frequency(fhz);
    l3gdev.format(8,mode);
}

/*---------------------------------constracta------------------------------------------*/
/*-----------------------------------member--------------------------------------------*/

int l3gd20::reg_reset(){
    int err;
    for(int i=CTRL_REG1; i<=REFERENCE; i++){
        err=l3gd20::write_8(i,0x00);
        if(err){
            return i;
        }
        if(i==CTRL_REG4){
            scale=250;
        }
    }
    err=l3gd20::write_8(FIFO_CTRL_REG,0x00);
    if(err){
        return FIFO_CTRL_REG;
    }
    err=l3gd20::write_8(INT1_CFG,0x00);
    if(err){
        return INT1_CFG;
    }
    for(int i=INT1_TSH_XH; i<=INT1_DURATION; i++){
        err=l3gd20::write_8(i,0x00);
        if(err){
            return i;
        }
    }
    return 0;
}

int l3gd20::conect(){
    int err;
    err=l3gd20::read_8(WHO_AM_I);
    if(err==0xD4){
        err=0;
    }else{
        err=1;
    }
    return err;
}

uint8_t l3gd20::read_8(uint8_t reg){
    uint8_t re;
    reg=reg|READ;
    l3gcs=0;
    l3gdev.write(reg);
    re=l3gdev.write(0x00);
    l3gcs=1;
    return re;
}

uint16_t l3gd20::read_16(uint8_t reg){
    uint8_t re1,re2;
    uint16_t re;
    reg=reg|READ;
    l3gcs=0;
    l3gdev.write(reg);
    re1=l3gdev.write(0x00);
    re2=l3gdev.write(0x00);
    re=(re1<<8)|re2;
    return re;
}

int l3gd20::write_8(uint8_t reg,uint8_t data){
    int err;
    reg=reg|WRITE;
    l3gcs=0;
    l3gdev.write(reg);
    l3gdev.write(data);
    l3gcs=1;
    err=l3gd20::read_8(reg);
    if(err==data){
        err=0;
    }else{
        err=1;
    }
    return err;
}

void l3gd20::s_write_8(uint8_t reg,uint8_t data){
    reg=reg|WRITE;
    l3gcs=0;
    l3gdev.write(reg);
    l3gdev.write(data);
    l3gcs=1;
}

int l3gd20::write_16(uint8_t reg,uint16_t data){
    int err;
    uint8_t d1,d2;
    d2=data&0xFF;
    d1=data>>8;
    reg=reg|WRITE;
    l3gcs=0;
    l3gdev.write(reg);
    l3gdev.write(d1);
    l3gdev.write(d2);
    l3gcs=1;
    err=l3gd20::read_16(reg);
    if(err==data){
        err=0;
    }else{
        err=1;
    }
    return err;
}