#ifndef _ARG_USEFUL_20150418_1411_
#define _ARG_USEFUL_20150418_1411_
/** @file
 */

//at matrix, place is from left to right and next, from up to down

/** (int)arg_subs :
 *
 * @bref substitution of arrangements
 * @param arg_to arrangement of what you want to submitition
 * @param arg_from arrangement of original
 * @param all_ele numbers of elements
 */
void arg_subs(int *arg_to,int *arg_from,int all_ele)
{
    for(int i=0; i<all_ele; i++)arg_to[i]=arg_from[i];
}

/** (float)arg_subs :
 *
 * @bref substitution of arrangements
 * @param arg_to arrangement of what you want to submitition
 * @param arg_from arrangement of original
 * @param all_ele numbers of elements
 */
void arg_subs(float *arg_to,float *arg_from,int all_ele)
{
    for(int i=0; i<all_ele; i++)arg_to[i]=arg_from[i];
}

/** (double)arg_subs :
 *
 * @bref substitution of arrangements
 * @param arg_to arrangement of what you want to submitition
 * @param arg_from arrangement of original
 * @param all_ele numbers of elements
 */
void arg_subs(double *arg_to,double *arg_from,int all_ele)
{
    for(int i=0; i<all_ele; i++)arg_to[i]=arg_from[i];
}

/** (int)arg_swap :
 *
 * @bref swap two arrangements
 * @param arg_a arrangement of what you want to swap
 * @param arg_b (same as arg_a)
 * @param all_ele numbers of elements
 */
void arg_swap(int *arg_a,int *arg_b, int all_ele)
{
    float c;
    for(int i=0; i<all_ele; i++){
        c=arg_a[i];
        arg_a[i]=arg_b[i];
        arg_b[i]=c;
    }
}

/** (float)arg_swap :
 *
 * @bref swap two arrangements
 * @param arg_a arrangement of what you want to swap
 * @param arg_b (same as arg_a)
 * @param all_ele numbers of elements
 */
void arg_swap(float *arg_a,float *arg_b, int all_ele)
{
    float c;
    for(int i=0; i<all_ele; i++){
        c=arg_a[i];
        arg_a[i]=arg_b[i];
        arg_b[i]=c;
    }
}

/** (double)arg_swap :
 *
 * @bref swap two arrangements
 * @param arg_a arrangement of what you want to swap
 * @param arg_b (same as arg_a)
 * @param all_ele numbers of elements
 */
void arg_swap(double *arg_a,double *arg_b, int all_ele)
{
    float c;
    for(int i=0; i<all_ele; i++){
        c=arg_a[i];
        arg_a[i]=arg_b[i];
        arg_b[i]=c;
    }
}

/** (int)arg_plus :
 *
 * @bref do addition of two matrix a[row][col]
 * @param ans matrix of answer 
 * @param arg_a matrix of what you want to add
 * @param arg_b (same as arg_a)
 * @param row numbers of elements of row
 * @param col numbers of elements of col
 */
void arg_plus(int *ans,int *arg_a,int *arg_b,int row,int col)
{
    for(int i=0; i<row; i++){
        for(int j=0; j<col; j++)ans[i*col+j] = arg_a[i*col+j]+arg_b[i*col+j];
    }
}

/** (float)arg_plus :
 *
 * @bref do addition of two matrix a[row][col]
 * @param ans matrix of answer 
 * @param arg_a matrix of what you want to add
 * @param arg_b (same as arg_a)
 * @param row numbers of elements of row
 * @param col numbers of elements of col
 */
void arg_plus(float *ans,float *arg_a,float *arg_b,int row,int col)
{
    for(int i=0; i<row; i++){
        for(int j=0; j<col; j++)ans[i*col+j] = arg_a[i*col+j]+arg_b[i*col+j];
    }
}

/** (double)arg_plus :
 *
 * @bref do addition of two matrix a[row][col]
 * @param ans matrix of answer 
 * @param arg_a matrix of what you want to add
 * @param arg_b (same as arg_a)
 * @param row numbers of elements of row
 * @param col numbers of elements of col
 */
void arg_plus(double *ans,double *arg_a,double *arg_b,int row,int col)
{
    for(int i=0; i<row; i++){
        for(int j=0; j<col; j++)ans[i*col+j] = arg_a[i*col+j]+arg_b[i*col+j];
    }
}

/** (int)arg_minus :
 *
 * @bref do subtraction of two matrix like a-b
 * @param ans matrix of answer 
 * @param arg_a matrix of what you want to minus
 * @param arg_b (same as arg_a)
 * @param row numbers of elements of row
 * @param col numbers of elements of col
 */
void arg_minus(int *ans,int *arg_a,int *arg_b,int row,int col)
{
    for(int i=0; i<row; i++){
        for(int j=0; j<col; j++)ans[i*col+j] = arg_a[i*col+j]-arg_b[i*col+j];
    }
}

/** (float)arg_minus :
 *
 * @bref do subtraction of two matrix like a-b
 * @param ans matrix of answer 
 * @param arg_a matrix of what you want to minus
 * @param arg_b (same as arg_a)
 * @param row numbers of elements of row
 * @param col numbers of elements of col
 */
void arg_minus(float *ans,float *arg_a,float *arg_b,int row,int col)
{
    for(int i=0; i<row; i++){
        for(int j=0; j<col; j++)ans[i*col+j] = arg_a[i*col+j]-arg_b[i*col+j];
    }
}

/** (double)arg_minus :
 *
 * @bref do subtraction of two matrix like a-b
 * @param ans matrix of answer 
 * @param arg_a matrix of what you want to minus
 * @param arg_b (same as arg_a)
 * @param row numbers of elements of row
 * @param col numbers of elements of col
 */
void arg_minus(double *ans,double *arg_a,double *arg_b,int row,int col)
{
    for(int i=0; i<row; i++){
        for(int j=0; j<col; j++)ans[i*col+j] = arg_a[i*col+j]-arg_b[i*col+j];
    }
}

/** (int)arg_multi :
 *
 * @bref do multiplication of two matrix like a*b
 * @param ans matrix of answer 
 * @param arg_a matrix of what you want to minus
 * @param row_a numbers of elements of row of arg_a
 * @param col_b numbers of elements of col of arg_a
 * @param arg_b (same as arg_a)
 * @param row_b numbers of elements of row of arg_b
 * @param col_b numbers of elements of col of arg_b
 * @retval 0 you can multiplication
 * @retval -1 you can't multiplication
 */
int arg_multi(int *ans,int *arg_a,int row_a,int col_a,int *arg_b,int row_b,int col_b)
{
    if(col_a!=row_b)return -1;
    else{
        for(int i=0; i<row_a; i++){
            for(int j=0; j<col_b; j++){
                ans[i*col_b+j]=0;
                for(int k=0; k<col_a; k++)ans[i*col_b+j]+=arg_a[i*col_a+k]*arg_b[j+col_b*k];
            }
        }
    }
    return 0;
}

/** (float)arg_multi :
 *
 * @bref do multiplication of two matrix like a*b
 * @param ans matrix of answer 
 * @param arg_a matrix of what you want to minus
 * @param row_a numbers of elements of row of arg_a
 * @param col_b numbers of elements of col of arg_a
 * @param arg_b (same as arg_a)
 * @param row_b numbers of elements of row of arg_b
 * @param col_b numbers of elements of col of arg_b
 * @retval 0 you can multiplication
 * @retval -1 you can't multiplication
 */
int arg_multi(float *ans,float *arg_a,int row_a,int col_a,float *arg_b,int row_b,int col_b)
{
    if(col_a!=row_b)return -1;
    else{
        for(int i=0; i<row_a; i++){
            for(int j=0; j<col_b; j++){
                ans[i*col_b+j]=0;
                for(int k=0; k<col_a; k++)ans[i*col_b+j]+=arg_a[i*col_a+k]*arg_b[j+col_b*k];
            }
        }
    }
    return 0;
}

/** (double)arg_multi :
 *
 * @bref do multiplication of two matrix like a*b
 * @param ans matrix of answer 
 * @param arg_a matrix of what you want to minus
 * @param row_a numbers of elements of row of arg_a
 * @param col_b numbers of elements of col of arg_a
 * @param arg_b (same as arg_a)
 * @param row_b numbers of elements of row of arg_b
 * @param col_b numbers of elements of col of arg_b
 * @retval 0 you can multiplication
 * @retval -1 you can't multiplication
 */
int arg_multi(double *ans,double *arg_a,int row_a,int col_a,double *arg_b,int row_b,int col_b)
{
    if(col_a!=row_b)return -1;
    else{
        for(int i=0; i<row_a; i++){
            for(int j=0; j<col_b; j++){
                ans[i*col_b+j]=0;
                for(int k=0; k<col_a; k++)ans[i*col_b+j]+=arg_a[i*col_a+k]*arg_b[j+col_b*k];
            }
        }
    }
    return 0;
}


#endif