// 着地の検出
// Author: Kaito Yamamoto from M.I.T.

//静止状態での各センサー値の変動(揺れ)、閾値
#define AX0_DELTA 10
#define AY0_DELTA 10
#define AZ0_DELTA 10
#define GX0_DELTA 10
#define GY0_DELTA 10
#define GZ0_DELTA 10
#define MAX_COUNT_FLAG 30
 
void landing_detect(){
    float axp, ayp, azp, gxp, gyp, gzp, ax_delta, ay_delta, az_delta, gx_delta, gy_delta, gz_delta;
    unsigned char count_flag;
    
    while( count_flag < MAX_COUNT_FLAG ){   //落下中のループ
        axp = ax; ayp = ay; azp = az;
        gxp = gx; gyp = gy; gzp = gz;
        Getdata();
        ax_delta = axp - ax; ay_delta = ayp - ay; az_delta = azp - az;   //センサー値の変化分の計算
        gx_delta = gxp - gx; gy_delta = gyp - gy; gz_delta = gzp - gz;
        
        if ( ax_delta > AX0_DELTA ){ count_flag = 0; }
        if ( ay_delta > AY0_DELTA ){ count_flag = 0; }
        if ( az_delta > AZ0_DELTA ){ count_flag = 0; }
        if ( gx_delta > GX0_DELTA ){ count_flag = 0; }
        if ( gy_delta > GY0_DELTA ){ count_flag = 0; }
        if ( gz_delta > GZ0_DELTA ){ count_flag = 0; }
        count_flag ++;
        wait(0.1);
    }
    twe.printf("Landing Complete\r\n");
}