/*
 * WS2812 tape led IC
 *
 *          0.35us   0.8us    (+-150ns)
 *  0:     |^^^^^|__________|
 *
 *             0.7us   0.6us  (+-150ns)
 *  1:     |^^^^^^^^^^|_____|
 *
 *               >50us
 *  RESET: |________________|
 */
#include "mbed.h"
#include "LEDStrip.h"

SPI tape(p11, p12, p13);

#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
    LPC_SSP_TypeDef *_ssp = LPC_SSP0;
#elif defined(TARGET_LPC11U24) || defined(TARGET_LPC11U35_501)
    LPC_SSPx_Type *_ssp = LPC_SSP1;
#endif

int num = 100;
int *data;
volatile int busy = 0, wakeup = 0;


extern "C"
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
void SSP0_IRQHandler() {
#elif defined(TARGET_LPC11U24) || defined(TARGET_LPC11U35_501)
void SSP1_IRQHandler() {
#endif
    static int addr = 0, bit = 0x800000;
repeat:
    if (busy) {
        // led data
      while (_ssp->SR & (1<<1)) { // TNF
        if (data[addr] & bit) {
            // 1
            //_ssp->DR = 0x01f;
            _ssp->DR = 0x01f;
        } else {
            // 0
            _ssp->DR = 0x007;   // パルスデータ変更 20160413
//            _ssp->DR = 0x00F;
        }
        bit = bit >> 1;
        if (bit == 0) {
            bit = 0x800000;
            addr ++;
            if (addr >= num) {
                addr = 0;
                busy = 0;
                goto repeat;
            }
        }
      }
    } else {
        // blank
        while (_ssp->SR & (1<<1)) { // TNF
            _ssp->DR = 0x000;
            //_ssp->DR = 0xfff;
//            if (addr < 50) {
            if (addr < 51) {    //  ループ回数1回増量 20160413
                addr ++;
            } else {
                addr = 0;
                if (wakeup) {
                    busy = 1;
                    wakeup = 0;
                    goto repeat;
                }
            }
        }
    }
}

void tapeInit (int freq, int n) {

    num = n;
//    data = new int(num);
    data = (int*)malloc(sizeof(int) * num);
    for (int i = 0; i < num; i ++) {
        data[i] = 0;
    }

    tape.format(10, 1);
    if (freq) {
        tape.frequency(freq * 1000);
    } else {
        tape.frequency(8000000);
    }
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
    NVIC_SetVector(SSP0_IRQn, (uint32_t)SSP0_IRQHandler);
    NVIC_SetPriority(SSP0_IRQn, 0);
    NVIC_EnableIRQ(SSP0_IRQn);
#elif defined(TARGET_LPC11U24) || defined(TARGET_LPC11U35_501)
    NVIC_SetVector(SSP1_IRQn, (uint32_t)SSP1_IRQHandler);
    NVIC_SetPriority(SSP1_IRQn, 0);
    NVIC_EnableIRQ(SSP1_IRQn);
#endif
    _ssp->IMSC |= (1<<3); // TXIM
}

void tapeSet (int n, int dat) {
    if (n >= 0 && n < num) {
        // RGB -> GRB
        data[n] = ((dat & 0xff0000) >> 8) | ((dat & 0xff00) << 8) | (dat & 0xff);
    }
}

void tapeSend () {
    if (busy) {
        while (busy);
        wait_us(50);
    }
    wakeup = 1;
    while (wakeup);
}

int tapeGet (int n) {
    return ((data[n] & 0xff0000) >> 8) | ((data[n] & 0xff00) << 8) | (data[n] & 0xff);
}
