#include "mbed.h"
#include "SB1602E.h"
#include "RCS730.h"

namespace {
    DigitalOut led(LED1);
    I2C i2c(I2C_SDA, I2C_SCL);
    SB1602E lcd(i2c);
    RCS730 felica(i2c);

    //PortIn po(PortA, 0x0300); // PA_8, PA_9
    InterruptIn int_rfdet(PA_8);
    InterruptIn int_irq(PA_9);
}

namespace {

    bool cbRxHTRead(void *pUser, uint8_t *pData, uint8_t Len)
    {
        uint8_t nob = pData[13] << 4;       //16byte * NoB
        pData[0] = static_cast<uint8_t>(13 + nob);
        pData[10] = 0;  //ST1
        pData[11] = 0;  //ST2
        for (int i = 0; i < nob; i++) {
            pData[13 + i] = static_cast<uint8_t>(i);
        }
        
        return true;
    }

    bool cbRxHTWrite(void *pUser, uint8_t *pData, uint8_t Len)
    {
        pData[16 + 16] = '\0';
        lcd.puts(1, reinterpret_cast<char*>(pData + 16));
        pData[0] = 12;
        pData[10] = 0;  //ST1
        pData[11] = 0;  //ST2
        
        return true;
    }
    
    void rfdetect_on()
    {
        led = !led;
    }
    
    void rfdetect_off()
    {
        led = 0;
    }
    
    void irq()
    {
        felica.isrIrq();
    }
}

int main()
{
    int ret;

    led = 0;
    lcd.puts(0, "OK ");
    
    int_rfdet.fall(rfdetect_on);
    int_rfdet.rise(rfdetect_off);
    
    int_irq.fall(irq);
 
    RCS730::callbacktable_t table = {
        0,
        cbRxHTRead,
        cbRxHTWrite
    };
    felica.setCallbackTable(&table);
    
    ret = felica.initFTMode(RCS730::OPMODE_PLUG);
    if (ret != 0) {
        lcd.puts(0, "1");
    }
    
    while(true) {
        ;
    }
}
