#include "mbed.h"
#include "ble/BLE.h"
#include "ble_nanoled_service.h"

namespace {
    const char DEVICE_NAME[] = "BLE Nano";
}

namespace {
    BLE             mBle;
    ServiceUart     mServiceUart;
}


namespace {
    inline int calcAdvertisingIntervalMs(int msec)
    {
        return 1000 * msec / 625;
    }
}


namespace {
    void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
    {
        mBle.gap().startAdvertising();
    }


    void writtenHandler(const GattWriteCallbackParams* params)
    {
        mServiceUart.writtenHandler(mBle, params);
    }
    
    void readHandler(const GattReadCallbackParams* params)
    {
        mServiceUart.readHandler(mBle, params);
    }
}


int main(void)
{
    mBle.init();
    mBle.onDisconnection(disconnectionCallback);
    mBle.onDataWritten(writtenHandler);
    mBle.onDataRead(readHandler);

    //services
    mServiceUart.addService(mBle);

    // setup advertising
    mBle.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    mBle.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    mBle.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME) - 1);
    // 100ms; in multiples of 0.625ms.
    mBle.setAdvertisingInterval(calcAdvertisingIntervalMs(100));
    mBle.startAdvertising();

    while (true) {
        mBle.waitForEvent();
    }
}

