#ifndef BLE_NANOLED_SERVICE_H__
#define BLE_NANOLED_SERVICE_H__

#include "mbed.h"
#include "ble/BLE.h"

class ServiceUart {
private:
    static const int TXRX_BUF_LEN = 20;
    static const int CHAR_NUM = 2;

public:
    void addService(BLE& ble);
    void writtenHandler(BLE& ble, const GattWriteCallbackParams* params);
    void readHandler(BLE& ble, const GattReadCallbackParams* params);

private:
    GattCharacteristic* mChars[CHAR_NUM];
    uint8_t mTxPayload[TXRX_BUF_LEN];
    uint8_t mRxPayload[TXRX_BUF_LEN];
};

#endif //BLE_NANOLED_SERVICE_H__
