#include "ble_nanoled_service.h"
#include "Led.h"

namespace {
    // The Nordic UART Service
    const uint8_t UUID_BASE[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
    const uint8_t UUID_TX[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
    const uint8_t UUID_RX[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
}


void ServiceUart::addService(BLE& ble)
{
    mChars[0] = new GattCharacteristic(
                            UUID_TX,
                            mTxPayload,
                            1,
                            TXRX_BUF_LEN,
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE
    );
    mChars[1] = new GattCharacteristic(
                            UUID_RX, 
                            mRxPayload, 
                            1, 
                            TXRX_BUF_LEN, 
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY
    );
    GattService* pService = new GattService(UUID_BASE, mChars, CHAR_NUM);
    ble.addService(*pService);
}


void ServiceUart::writtenHandler(BLE& ble, const GattWriteCallbackParams* params)
{
    if (params->handle == mChars[0]->getValueAttribute().getHandle()) {
        uint8_t buf[TXRX_BUF_LEN];
        uint16_t bytesRead;

        ble.readCharacteristicValue(mChars[0]->getValueAttribute().getHandle(), buf, &bytesRead);
        if(buf[0] == 0x01) {
            LedOn();
        } else {
            LedOff();
        }
    }
}

void ServiceUart::readHandler(BLE& ble, const GattReadCallbackParams* params)
{
    if (params->handle == mChars[1]->getValueAttribute().getHandle()) {
        //...
    }
}

