class TMP36
{
public:
    TMP36(PinName pin);
    TMP36();
    operator float ();
    float read();
    float readFah();
private:
//sets up the AnalogIn pin
    AnalogIn _pin;
};
 
TMP36::TMP36(PinName pin) : _pin(pin)
{
// _pin(pin) means pass pin to the AnalogIn constructor
}
 
float TMP36::read()
{
//convert sensor reading to temperature in degrees C
    return ((_pin.read()*3.3)-0.500)*100.0;
}

float TMP36::readFah()
{
    float tempC = ((_pin.read()*3.3)-0.500)*100.0;
    return 9.0*(tempC)/5.0 + 32.0;
        
}

//overload of float conversion (avoids needing to type .read() in equations)
TMP36::operator float ()
{
//convert sensor reading to temperature in degrees C
    return ((_pin.read()*3.3)-0.500)*100.0;
}
           