#include "mbed.h"
#include "NeoStrip.h"
#include "gt.h"
#define N 64
#define PATTERNS 3
Ticker flipper;
int hueToRGB(float h);



AnalogIn photocell(p16);
RawSerial  dev(p28,p27);
NeoStrip strip(p18, N);
DigitalOut myled(LED1);
InterruptIn vibration(p15); 
Serial pc(USBTX,USBRX);
int count = 0; 
int senseValCur; 
int senseValPre = 1;
char bred=0;
    char bgreen=0;
    char bblue=0;   
// timer used for debugging
Timer timer;
int hueToRGB2(int r, int g, int b);

int hueToRGB2(int r, int g, int b)
{
    // scale to integers and return the packed value
    uint8_t R = (uint8_t)(r);
    uint8_t G = (uint8_t)(g);
    uint8_t B = (uint8_t)(b);

    return (R << 16) | (G << 8) | B;
}

int hueToRGB(float h)
{
	// lots of floating point magic from the internet and scratching my head
	float r, g, b;
	if (h > 360)
		h -= 360;
	if (h < 0)
		h += 360;
	int i = (int)(h / 60.0);
	float f = (h / 60.0) - i;
	float q = 1 - f;
	
	switch (i % 6)
	{
		case 0: r = 1; g = f; b = 0; break;
		case 1: r = q; g = 1; b = 0; break;
		case 2: r = 0; g = 1; b = f; break;
		case 3: r = 0; g = q; b = 1; break;
		case 4: r = f; g = 0; b = 1; break;
		case 5: r = 1; g = 0; b = q; break;
		default: r = 0; g = 0; b = 0; break;
	}
	// scale to integers and return the packed value
	uint8_t R = (uint8_t)(r * 255);
	uint8_t G = (uint8_t)(g * 255);
	uint8_t B = (uint8_t)(b * 255);

	return (R << 16) | (G << 8) | B;
}

void flip(){
	myled = !myled;
	senseValCur = 0;
	//if(senseValCur == 0)
		//{
		 strip.setBrightness(photocell/4);
          static float dh = 360.0 / N;
			static float x = 0;

			for (int i = 0; i < N; i++)
			{strip.setPixel(i, hueToRGB((dh * i) - x));

	
			x += 1;
			if (x > 360)
			x = 0;
			strip.write();
			wait(0.01);}
          
          
          for (int i = 0; i < N; i++)
            {strip.setPixel(i, hueToRGB2(bred,bgreen,bblue)); //blue red green

    
            x += 1;
            if (x > 360)
            x = 0;
            strip.write();
            wait(0.01);}
            count++;
        pc.printf("%i\n\r",count);
        dev.printf("%i\n\r",count);
        //senseValCur = 1;
        //}
        senseValPre = senseValCur;	
}
int main()
{
	vibration.mode(PullUp);
	int set = 0;
	float bright = 0.2;	// 20% is plenty for indoor use
  //flipper.attach(&flip,5);	
   // while(set < 4){
    	
		//set++;
		//}
	
	strip.setBrightness(bright);	// set default brightness
	while (true)
	{
		vibration.rise(&flip);
		strip.setBrightness(photocell);
		//myled = vibration.read();
		//myled = !myled;
		//senseValCur = vibration.read();
		timer.reset(); // use a timer to measure loop execution time for debugging purposes
		timer.start(); // for this application, the main loop takes approximately 3ms to run
		 if (dev.getc()=='!') {
            if (dev.getc()=='C') { //color data packet
                bred = dev.getc(); // RGB color values
                bgreen = dev.getc();
                bblue = dev.getc();
            
                if (dev.getc()==char(~('!' + 'C' + bred + bgreen + bblue))) {
                   static float x = 0;

            for (int i = 0; i < N; i++)
            {strip.setPixel(i, hueToRGB2(bred,bgreen,bblue)); //blue red green

    
            x += 1;
            if (x > 360)
            x = 0;
            strip.write();
            wait(0.01);}
             
                }
        }
		}
		
		
        
	}
}



