//Joel Shearon and Van Mang ECE 4180 Mini Project
#include "mbed.h"
#include "HTU21D.h"
#include "TMP36.h"
#include "string"
#include "SCP1000.h"
SCP1000 scp1000(p5,p6,p7,p8);
TMP36 tmp36(p20);
Ticker flipper;
AnalogIn photocell(p15);
string sun;
PwmOut myled(LED1);
RawSerial  dev(p28,p27);
RawSerial ble(p13,p14);
DigitalOut led1(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX); 
HTU21D temphumid(p9, p10); // Temp Module || sda, SCL
string options[7] = {"moonless cloudy night \n\r"
,"moonlit night \n\r"
,"dark room\n\r"
,"dark overcast day \n\r"
,"overcast day \n\r"
,"full day \n\r"
,"full sun \n\r"};

void dev_recv()
{
    led1 = !led1;
    while(dev.readable()) {
        pc.putc(dev.getc());
    }
}
 
void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}

void flip() {
        float readPhoto = photocell.read()*3.3;
        if (readPhoto < 0.15f)
        { sun = options[0];
         }
        else if (readPhoto < 0.412f)
        { sun = options[1];
         } 
        else if (readPhoto < 1.65f)
        { sun = options[2];
         }
        else if (readPhoto < 1.34f){
            sun = options[3];
        }
        else if (readPhoto < 3.2f)
        { sun = options[4];
         }
        else if (readPhoto < 3.26f)
        { sun = options[5];
         }
        else if (readPhoto >= 3.26f)
        { sun = options[6];
         }  
}
//start of main
 
int main()
{
    char bnum=0;
    char bhit=0;
    pc.baud(9600);
    dev.baud(9600);
    float tempC, tempF;
        pc.attach(&pc_recv, Serial::RxIrq);
        dev.attach(&dev_recv, Serial::RxIrq);
        flipper.attach(&flip, 1); 
    while(1) {
        wait(1);
        //conversion to degrees C - from sensor output voltage per LM61 data sheet
        tempC = tmp36.read();
        //printf("percentage: %3.3f%%\n", tmp36.read());
        //wait(0.5);
        //convert to degrees F
        tempF = tmp36.readFah();
        
        if (ble.getc()=='!') {
            if (ble.getc()=='B') { //button data packet
                bnum = ble.getc(); //button number
                bhit = ble.getc(); //1=hit, 0=release
                if (ble.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //dev.printf("1");
                                tempC = tmp36.read();
                                tempF = tmp36.readFah();
                                dev.printf("%5.2F C %5.2F F \n\r", tempC, tempF);
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //dev.printf("2");
                                dev.printf("Humidity Is: %i %%\n\r", temphumid.sample_humid());
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //dev.printf("3");
                                dev.printf("the sun level is: %s", sun);
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //dev.printf("4");
                                dev.printf("The pressure is %d Pa", scp1000.readPressure());
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //dev.printf("5");
                                tempC = tmp36.read();
                                tempF = tmp36.readFah();
                                dev.printf("%5.2F C %5.2F F \n\r", tempC, tempF);
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //dev.printf("6");
                                dev.printf("Humidity Is: %i %%\n\r", temphumid.sample_humid());
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //dev.printf("7");
                                dev.printf("the sun level is: %s", sun);
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //dev.printf("8");
                                dev.printf("The pressure is %d Pa", scp1000.readPressure());
                            }
                            break;
                        default:
                            break;
                    }
            }
        }
    }
    }
}