#include "mbed.h"
#include <sstream>
#include "easy-connect.h"
#include "https_request.h"
#include "ssl_ca_pem.h"
#include "C12832.h"

C12832 lcd(D11, D13, D12, D7, D10);
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn fire(D4);
PwmOut spkr(D6);

Serial pc(USBTX,USBRX);

const char API_TOKEN[] = "api-token";
const char URL[] = "https://owtd6.cybozu.com/k/v1/record.json";

int app_id = 2;

// JSON simplicity parser
char* j_paser( const char *buf , char *word , char *out )
{
    int i = 0;
    char *p;
    char _word[64] = "\"\0";

    strcat(_word , word );
    strcat(_word , "\"" );

    p = strstr( (char*)buf , _word ) + 2 + strlen(_word);
    
    while( (p[i] != ',')&&(p[i] != '\n')&&(p[i] != '"') )
    {
        out[i] = p[i];
        i++;
    }
    out[i] = '\0';
    
    return p;
}

// main() runs in its own thread in the OS
int main() {
    NetworkInterface* network = NULL;

    pc.baud(115200);

    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Network Connect..");

    pc.printf("\r\n----- Start -----\r\n");
    
    network = easy_connect(true);    // If true, prints out connection details.
    if (!network) {
        lcd.printf("NG");
        pc.printf("\r\n----- Network Error -----\r\n");
        return -1;
    }

    lcd.printf("OK");
    pc.printf("\r\n----- Network Connected -----\r\n");
    
    wait(2.0);
    
    while(1){
        int id = 1;
        
        // ID select
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Please select id.");
        while(fire == 0){
            lcd.locate(0,14);
            lcd.printf("id = ");
            if( up == 1) id++;
            if( down == 1) id--;
            lcd.printf("%d     ",id);
            wait(0.2);
        }
        
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("It is polling with the selected id.");
                
        // Set url
        std::stringstream ss_url;
        std::string s_url(URL);
        
        ss_url << s_url << "?app=" << app_id << "&id=" << id;
        
        string url = ss_url.str();
        
        pc.printf("%s\r\n",url.c_str());
        
        while(1){
            pc.printf("\r\n----- HTTPS GET request -----\r\n");
            HttpsRequest* get_req = new HttpsRequest(network, SSL_CA_PEM, HTTP_GET, url.c_str());
            
            get_req->set_header("X-Cybozu-API-Token", API_TOKEN);
            
            HttpResponse* get_res = get_req->send();
            
            pc.printf("\n----- HTTPS GET response [%d]-----\n",get_res->get_status_code());
            
            if(get_res->get_status_code() == 200){
                pc.printf("\n----- HTTPS GET response 200 -----\n");
                const char* body = get_res->get_body_as_string().c_str();
                
                pc.printf("%s\r\n",body);
                
                // Response JSON parse
                char value[256];
                
                char* p = j_paser(body,"日付",value);
                j_paser(p,"value",value);
                printf("date:%s\r\n",value);
                
                lcd.cls();
                lcd.locate(0,3);
                lcd.printf("Date:%s",value);
                
                p = j_paser(body,"文字列__1行_",value);
                j_paser(p,"value",value);
                printf("%s\r\n",value);
                
                lcd.locate(0,14);
                lcd.printf("name:%s",value);
                
                // Sound an alert
                spkr.period(1.0/5000.0);
                spkr=0.5;
                wait(1.0);
                spkr=0.0;
                
                delete get_req;
                
                break;
            }
            
            delete get_req;
            
            wait(10.0);
        }
        
        while(fire == 0);
        wait(1.0);
    }
}

