#include "auto2wheel.h"
#include "mbed.h"
#include "QEI.h"
#include "PID_mty.h"
#include <cstdarg>
#include <cstring> 
#include "pwmin.h"
#define MAX_V 344.0//电机最大速度

//编码器+PIDcontroler+automobile
QEI wheel1(PB_3, PB_4, NC, 11, QEI::X4_ENCODING);
QEI wheel2(PA_9, PA_10, NC, 11, QEI::X4_ENCODING);
PID pid1,pid2;
auto2wheel my_auto;
//bluetooth serial
Serial bt(PA_2,PA_3);
//Serial Tim3_ser1(PB_10,PB_11);
Ticker toggle_time_ticker;
void time_ticker();

double get_v1,get_v2;//编码器读取速度
double delta1=0.0,delta2=0.0;//pid 返回值
double speed1=0;//初始速度
double speed2=0;//初始速度

void time_ticker(){
//    Tim3_ser1.printf(" %d  %d\n",tim3IC3Width, tim3IC4Width);
    if((1200<tim3IC3Width<1800)||(1200<tim3IC4Width<1800))// controler without pid
    {
        my_auto.mv_x(0,0);
    }
    if(tim3IC3Width<1200||tim3IC3Width>1800)
    {
        my_auto.spin(-tim3IC3Width+1450);   
    }
    if(tim3IC4Width<1200||tim3IC4Width>1800)
    {
        my_auto.mv_x(-tim3IC4Width+1450,-tim3IC4Width+1450);
    }
        
    get_v1 = (double)wheel1.getPulses();
    get_v2=(double)wheel2.getPulses();
    delta1=compute(&pid1,get_v1);
    delta2=compute(&pid2,get_v2);
    speed1+=delta1;
    speed2+=delta2;
    wheel1.reset();
    wheel2.reset();
}

    typedef enum
{
    CheckS,CheckW,Checka,Checkb,Checkc,Checkd,Checke,Checkf,CheckSum
}STATE;

void btserialread(){//蓝牙读取PID
    char u1Rec; 
    static STATE State = CheckS;//初始状态待检查
    static char PositionTemp[7]={0,0,0,0,0,0,0};//装载数据值a(左右转) b(前后退) c(机械手高度) d(机械手旋转角度) Sum(求和校验)
    u1Rec = bt.getc(); 
    switch(State)
    {
        case CheckS:
            if(u1Rec==(char)'S')
                State=CheckW;//准备跳转至数据读取
            else
                State=CheckS;
            break;
        case CheckW:
            if(u1Rec==(char)'W')
            State=Checka;
            else if(u1Rec==(char)'S')
                State=CheckW;
            else 
                State=CheckS;
            break;
        case Checka:
            PositionTemp[0]=u1Rec;
            State=Checkb;
            break;
        case Checkb:
            PositionTemp[1]=u1Rec;
            State=Checkc;
            break;
        case Checkc:
            PositionTemp[2]=u1Rec;
            State=Checkd;
            break;
        case Checkd:
            PositionTemp[3]=u1Rec;
            State=Checke;
            break;
        case Checke:
            PositionTemp[4]=u1Rec;
            State=Checkf;
            break;
        case Checkf:
            PositionTemp[5]=u1Rec;
            State=CheckSum;
            break;
        case CheckSum:
            PositionTemp[6]=u1Rec;
            if(PositionTemp[6]==(char)(PositionTemp[0]+PositionTemp[1]+PositionTemp[2]+PositionTemp[3]+PositionTemp[4]+PositionTemp[5]))
            {
                pid1.P = PositionTemp[0]/10.0;
                pid1.I = PositionTemp[1]/10.0;
                pid1.D = PositionTemp[2]/10.0;
                pid2.P = PositionTemp[3]/10.0;
                pid2.I = PositionTemp[4]/10.0;
                pid2.D = PositionTemp[5]/10.0;
                pc.printf("1P:%f    1I:%f   1D:%f   2P:%f   2I:%f   2D:%f\n",pid1.P,pid1.I,pid1.D,pid2.P,pid2.I,pid2.D);
            }
            State=CheckS;
            break;
        default:
            State=CheckS;
            break;
    }
}
//0.432x+831.928
int main()
{
    //controler
    HAL_Init();
    TIM1_3_Config();
    
    pid1.LastError=pid1.PrevError=pid1.SumError=0.0;
    pid2.LastError=pid2.PrevError=pid2.SumError=0.0;
    bt.attach(&btserialread); 
    wheel1.reset();
    wheel2.reset();
    toggle_time_ticker.attach(&time_ticker, 0.2);
}
