#include "mbed.h"
Serial pc(USBTX, USBRX);
Serial esp(p9, p10); // tx, rx
Timer t;
char buf[1024];
char snd[255];
int  count;
int timeout,ended;
char ssid[32] = "Chaitanya1";     // enter WiFi router ssid inside the quotes
char pwd [40] = "9632964359"; // enter WiFi router password inside the quotes
void SendCMD(),getreply();

int main() {
    pc.baud(9600);
    esp.baud(9600);
    
    strcpy(snd,"AT\r\n");
    SendCMD();
    timeout=1;
    getreply();
    pc.printf(buf);
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "AT+CWMODE=3\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);

    wait(2);
     pc.printf("\n---------- Listing Access Points ----------\r\n");
    strcpy(snd, "AT+CWLAP\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
    wait(2);

    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
wait(5);
pc.printf("\n---------- Get IP's ----------\r\n");
    strcpy(snd, "AT+CIFSR\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);
    wait(1);

    pc.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "AT+CIPSTATUS\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
    
}
void SendCMD()
{
    esp.printf("%s", snd);
}
void getreply()
{ 
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        
        
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}