#include "mbed.h"
 
#include "Keypad.h"
 
Serial        PC(USBTX, USBRX);
 
// Define your own keypad values
char Keytable[] = { '1', '2', '3',   // r0
                    '4', '5', '6',   // r1
                    '7', '8', '9',
                    '0'   // r2
                  // c0   c1   c2
                  };
 
int32_t       Index = -1;
int           State;
 
uint32_t cbAfterInput(uint32_t index)
{
    Index = index;
    return 0;
}
 
int main()
{
    PC.printf("I am Demo Keypad\r\n");
    
    //             r0   r1   r2   r3   c0   c1   c2   c3
    Keypad keypad(p21, p22,  p23,  p24, p25, p26,  p27,  p28);
    keypad.attach(&cbAfterInput);
    keypad.start();  // energize the columns c0-c3 of the keypad
 
    while (1) {
        __wfi();
        if (Index > -1) {
            PC.printf("Interrupted");
            PC.printf("Index:%d => Key:%c\r\n", Index, Keytable[Index]);
            Index = -1;
        }
    }
}