#include "mbed.h"

static const double MIN_T = 0.04;
static const double MAX_T = 0.20;

int main() {
    DigitalOut led[] = {LED1, LED2, LED3, LED4};

    double t = MAX_T;
    int dir = -1;    // decrement
    for (;;) {
        for (int i = 0; i <= 2; i++) {
            led[i] = 1;
            wait(t);
            led[i] = 0;
        }
        for (int i = 3; i >= 1; i--) {
            led[i] = 1;
            wait(t);
            led[i] = 0;
        }

        t += dir * 0.01;
        if (t >= MAX_T || t <= MIN_T) {
            dir = -dir;
        }
    }
}