/******************************************************************************
 * Developed from
 * VL6180X_demo.ino
 * Example Sketch for VL6180x time of flight range finder.
 * Casey Kuhns @ SparkFun Electronics
 * 10/29/2014
 * https://github.com/sparkfun/ToF_Range_Finder-VL6180_Library
 * 
 * The VL6180x by ST micro is a time of flight range finder that
 * uses pulsed IR light to determine distances from object at close
 * range.  The average range of a sensor is between 0-200mm
 * 
 * Resources:
 * This library uses the Arduino Wire.h to complete I2C transactions.
 * 
 * Development environment specifics:
 *  IDE: Arduino 1.0.5
 *  Hardware Platform: Arduino Pro 3.3V/8MHz
 *  VL6180x Breakout Version: 1.0
 * 
 * 
 * This code is beerware. If you see me (or any other SparkFun employee) at the
 * local pub, and you've found our code helpful, please buy us a round!
 * 
 * Distributed as-is; no warranty is given.
 ******************************************************************************/
#include "mbed.h"
#include <VL6180x.h>

/*const float GAIN_1    = 1.01;  // Actual ALS Gain of 1.01
const float GAIN_1_25 = 1.28;  // Actual ALS Gain of 1.28
const float GAIN_1_67 = 1.72;  // Actual ALS Gain of 1.72
const float GAIN_2_5  = 2.6;   // Actual ALS Gain of 2.60
const float GAIN_5    = 5.21;  // Actual ALS Gain of 5.21
const float GAIN_10   = 10.32; // Actual ALS Gain of 10.32
const float GAIN_20   = 20;    // Actual ALS Gain of 20
const float GAIN_40   = 40;    // Actual ALS Gain of 40
*/

#define VL6180X_ADDRESS 0x29

VL6180xIdentification identification;
// mbed uses 8bit addresses shift address by 1 bit left
VL6180x sensor(D14, D15, VL6180X_ADDRESS<<1);
void printIdentification(struct VL6180xIdentification *temp){
  printf("Model ID = ");
  printf("%d\n",temp->idModel);

  printf("Model Rev = ");
  printf("%d",temp->idModelRevMajor);
  printf(".");
  printf("%d\n",temp->idModelRevMinor);

  printf("Module Rev = ");
  printf("%d",temp->idModuleRevMajor);
  printf(".");
  printf("%d\n",temp->idModuleRevMinor);  

  printf("Manufacture Date = ");
  printf("%d",((temp->idDate >> 3) & 0x001F));
  printf("/");
  printf("%d",((temp->idDate >> 8) & 0x000F));
  printf("/1");
  printf("%d\n",((temp->idDate >> 12) & 0x000F));
  printf(" Phase: ");
  printf("%d\n",(temp->idDate & 0x0007));

  printf("Manufacture Time (s)= ");
  printf("%d\n",(temp->idTime * 2));
  printf("\n\n");
}

int main() {
  uint8_t retaddr;
  wait_ms(100); // delay .1s

  sensor.getIdentification(&identification); // Retrieve manufacture info from device memory
  printIdentification(&identification); // Helper function to print all the Module information

  if(sensor.VL6180xInit() != 0){
        printf("FAILED TO INITALIZE\n"); //Initialize device and check for errors
  }; 

  sensor.VL6180xDefautSettings(); //Load default settings to get started.
  
  wait_ms(1000); // delay 1s
 
      printf("Ambient Light Level (Lux) = ");
      printf("%f\n",sensor.getAmbientLight(GAIN_1) );
  
  wait_ms(1000); // delay 1s
  //
  printf("Change sensor address to 0x27\n");
  retaddr=sensor.changeAddress(0x29,0x27);
  printf("Sensor addres is now %x\n",retaddr);
  sensor.getIdentification(&identification); // Retrieve manufacture info from device memory
  printIdentification(&identification); // Helper function to print all the Module information
  printf("Ambient Light Level (Lux) = ");
  printf("%f\n",sensor.getAmbientLight(GAIN_1) );   
  
  wait_ms(1000); // delay 1s
  printf("Change sensor address back to 0x29\n");
  retaddr=sensor.changeAddress(0x27,0x29);
  printf("Sensor addres is now %x\n",retaddr);
  sensor.getIdentification(&identification); // Retrieve manufacture info from device memory
  printIdentification(&identification); // Helper function to print all the Module information
  printf("Ambient Light Level (Lux) = ");
  printf("%f\n",sensor.getAmbientLight(GAIN_1) );   
 
    while(1) {
  //Get Ambient Light level and report in LUX
      printf("Ambient Light Level (Lux) = ");
  
  //Input GAIN for light levels, 
  // GAIN_20     // Actual ALS Gain of 20
  // GAIN_10     // Actual ALS Gain of 10.32
  // GAIN_5      // Actual ALS Gain of 5.21
  // GAIN_2_5    // Actual ALS Gain of 2.60
  // GAIN_1_67   // Actual ALS Gain of 1.72
  // GAIN_1_25   // Actual ALS Gain of 1.28
  // GAIN_1      // Actual ALS Gain of 1.01
  // GAIN_40     // Actual ALS Gain of 40
  
      printf("%f\n",sensor.getAmbientLight(GAIN_1) );

  //Get Distance and report in mm
      printf("Distance measured (mm) = ");
      printf("%d\n", sensor.getDistance() ); 
  //Get Distance and report in mm
      printf("Distance measured (m) = ");
      printf("%f\n", sensor.getDistance_m() ); 

      wait_ms(500); 
 
    }
}





