//w5100
#include "mbed.h"
#include "WIZnetInterface.h"
#include <string>

#define ECHO_SERVER_PORT   80


WIZnetInterface eth(SPI_MOSI, SPI_MISO, SPI_SCK,SPI_CS,PB_4); // spi, cs, reset
Serial pc(SERIAL_TX,SERIAL_RX);
// theres a conflict with LED1 on the Nucleo board it uses the same pin as SPI_SCK!
//DigitalOut led(LED1);
// This is the chip select for the sd card which shares the SPI bus on the Arduino shield.
DigitalOut SD_CS(PB_5);


void f_ethernet_init(void);

const char * IP_Addr    = "192.168.1.210";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.1.1";
char data[8];

int ret;
bool status;


char paq_en[64];
#define THING_SPEAK_IP_STR      "184.106.153.149" /* thingspeak.com IP Address */
#define THING_SPEAK_IP_PORT     80 /* port number */
#define THING_SPEAK_KEY_STR     "94XG0UQQXJ28F1QM" /* API key */
#define THING_SPEAK_CHANNEL     21931 /* channel ID */
#define THING_SPEAK_LABEL_STR   "field1"
char * str0 = "POST /update HTTP/1.1\n";
char * str1 = "Host: api.thingspeak.com\n";
char * str2 = "Connection: close\n";
char * str3 = "X-THINGSPEAKAPIKEY: ";
char * str4 = "Content-Type: application/x-www-form-urlencoded\n";
char * write_key = "94XG0UQQXJ28F1QM";
char * str5 = "Content-Length: ";

void updateThingSpeak(char * tsData)
{
}    

int main()
{
// force the chip select for the SD card high to avoid collisions. We're not using the sd card for this program    
    char buffer[64];
    char data_entry[64];
    SD_CS=1;
    uint8_t mac[]={0x90,0xa2,0xDa,0x0d,0x42,0xe0};
    int attempt=0;    
    int entry=42;
    int length;
    f_ethernet_init();
    TCPSocketConnection client;
//
    
    while (attempt < 4){   
    pc.printf("\nWaiting for connection to ThingSpeak server...\n");    
    ret=client.connect(THING_SPEAK_IP_STR,THING_SPEAK_IP_PORT);
    if (!ret) {
            pc.printf("\nConnected to ThingSpeak server\n");
            }
       else {
                       pc.printf("\nConnection attempt to ThingSpeak server failed\n");
                       attempt++;
            }
    if (client.is_connected() ) // try to send data
    { 
// update function
     client.send(str0,strlen(str0));
     pc.printf("%s >%d",str0,strlen(str0));
     client.send(str1,strlen(str1));
     pc.printf("%s >%d",str1,strlen(str1));
     client.send(str2,strlen(str2));
     pc.printf("%s >%d",str2,strlen(str2));
     sprintf(buffer,"%s %s\n",str3,write_key);
     client.send(buffer,strlen(buffer));
     pc.printf("%s >%d",buffer,strlen(buffer));
     client.send(str4,strlen(str4));
     pc.printf("%s >%d",str4,strlen(str4));
     sprintf(data_entry,"field1=%d\n",entry);
     length=strlen(data_entry);
     sprintf(buffer,"Content-Length: %d\n\n",length);
     pc.printf("%s >%d",buffer,strlen(buffer));
     pc.printf("%s >%d",data_entry,strlen(data_entry));
     client.send(buffer,strlen(buffer));
     client.send(data_entry,strlen(data_entry));
     entry++;
     wait(20.0);
    }   
}
}

void f_ethernet_init()
{
    uint8_t mac[]={0x90,0xa2,0xDa,0x0d,0x42,0xe0};
    // mbed_mac_address((char *)mac); 
    pc.printf("\tStarting Ethernet Server ...\n\r");
    wait(1.0);
    ret = eth.init(mac);
    if(!ret)
    {
        pc.printf("Initialized, MAC= %s\n\r",eth.getMACAddress());
    }    
    else
    {
        pc.printf("Communication Failure  ... Restart devices ...\n\r");    
    }
    pc.printf("Connected");
    wait(0.5);
    pc.printf(".");
    wait(0.5);
    pc.printf(".\n\r");
    wait(0.5);
    ret = eth.connect();
    if(!ret)
    {
        pc.printf("Connection Established!\n\n\r");
        wait(1);
        pc.printf("IP=%s\n\rMASK=%s\n\rGW=%s\n\r",eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    }    
    else
    {
        pc.printf("Communication Failure  ... Restart devices ...\n\r"); 
    }
}  
 