/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
and associated documentation files (the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

/*
 *    The application works with the BLEController iOS/Android App.
 *    Type something from the Terminal to send
 *    to the BLEController App or vice verse.
 *    Characteristics received from App will print on Terminal.
 */
 
// Import libraries 
#include "Arduino.h"
#include "BLEPeripheral.h"
#include "MMA8451Q.h"
#include "stdio.h"
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)
 

Serial serial(USBTX, USBRX);

// The SPI construct, REQN and RDYN IO construct should be modified manually
// It depend on the board you are using and the REQN&RDYN configuration on BLE Shield
// config for KL25Z
// VIN to 5V on KL25
// GND to GND on KL25
SPI spi(PTD2, PTD3, PTD1);    // MOSI , MISO , SCLK  
DigitalInOut BLE_RDY(PTD5);  // 
DigitalInOut BLE_REQ(PTD0);   // 
DigitalInOut BLE_RESET(PTA13); 

unsigned char txbuf[16] = {0};
unsigned char txlen = 0;
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
Ticker sensor_out;

//*----- BLE Utility -------------------------------------------------------------------------*/
// create peripheral instance, see pinouts above
BLEPeripheral            blePeripheral        = BLEPeripheral(&BLE_REQ, &BLE_RDY, &BLE_RESET);
 
// create service
BLEService               uartService          = BLEService("6E400001-B5A3-F393-E0A9-E50E24DCCA9E");
 
// create characteristic
BLECharacteristic    txCharacteristic = BLECharacteristic("6E400003-B5A3-F393-E0A9-E50E24DCCA9E", BLENotify, 20);
BLECharacteristic    rxCharacteristic = BLECharacteristic("6E400002-B5A3-F393-E0A9-E50E24DCCA9E", BLEWriteWithoutResponse, 20);
/*--------------------------------------------------------------------------------------------*/
//
// Nordic characteristics work with Nordic and Bluefruit LE apps
// uartService 6E400001-B5A3-F393-­E0A9-­E50E24DCCA9E
// txCharacteristic 6E400003-B5A3-F393-­E0A9-­E50E24DCCA9E
// rxCharacteristic 6E400002-B5A3-F393-­E0A9-­E50E24DCCA9E
// RedBearLabs characteristics work with RedBear BLE Controller app
// uartService 713d0000503e4c75ba943148f18d941e
// txCharacteristic 713d0002503e4c75ba943148f18d941e
// rxCharacteristic 713d0003503e4c75ba943148f18d941e



unsigned int interval = 0;
unsigned char count_on = 0;
void sens()
{
  char sensbuf[16];
  char senslen;
  float accZ = abs(acc.getAccZ());

  serial.printf("measured %f \r\n",accZ);
  sprintf(sensbuf,"%f",accZ);
  senslen=strlen(sensbuf);
  txCharacteristic.setValue((const unsigned char *)sensbuf, senslen);
}
int main()
{ 
    serial.baud(115200);
    serial.printf("Serial begin!\r\n");
    
    /*----- BLE Utility ---------------------------------------------*/
    // set advertised local name and service UUID
    blePeripheral.setLocalName("BLE Shield");
    
    blePeripheral.setAdvertisedServiceUuid(uartService.uuid());
    
    // add service and characteristic
    blePeripheral.addAttribute(uartService);
    blePeripheral.addAttribute(rxCharacteristic);
    blePeripheral.addAttribute(txCharacteristic);
    
    // begin initialization
    blePeripheral.begin();
    /*---------------------------------------------------------------*/
    
    serial.printf("BLE UART Peripheral begin!\r\n");
    
    
    while(1)
    {
        BLECentral central = blePeripheral.central();
        
        if (central) 
        {
            // central connected to peripheral
            serial.printf("Connected to central\r\n");
            sensor_out.attach(&sens, 2.0); // the address of the function to be attached (sens) and the interval (2 seconds)           
            while (central.connected()) 
            {
 
                // central still connected to peripheral
                if (rxCharacteristic.written()) 
                {
                    unsigned char rxlen = rxCharacteristic.valueLength();
                    const unsigned char *val = rxCharacteristic.value();
                    serial.printf("didCharacteristicWritten, Length: %d\r\n", rxlen); 
                    unsigned char i = 0;
                    while(i<rxlen)
                    {
                        serial.printf("%d, ",val[i++]);
                    }
                    serial.printf("\r\n");
                }
                 
                if(serial.readable())   // Do not spend much time on doing other things when serial available! Otherwisee, data will lose. 
                {
                    if(!count_on)
                    {
                        count_on = 1;
                    }
                    interval = 0;
                    txbuf[txlen] = serial.getc();
                    txlen++;
                }
                
                if(count_on)    // Count the interval after receiving a new char from terminate
                {
                    interval++;
                }
                
                if(interval == 10)   // If there is no char available last the interval, send the received chars to central.
                {
                    interval = 0;
                    count_on = 0;
                    
                    serial.printf("Received from terminal: %d bytes\r\n", txlen);
                    txCharacteristic.setValue((const unsigned char *)txbuf, txlen);
                    txlen = 0;
                }
            }
        
            // central disconnected
            sensor_out.detach();
            serial.printf("Disconnected from central\r\n");
        }
    }
}
