#include "mbed.h"
 
#define chan    6         // the numbers of channels

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

InterruptIn ch1(p17);       // yaw
InterruptIn ch2(p18);       // pitch
InterruptIn ch3(p19);       // throttle
InterruptIn ch4(p20);       // roll
//InterruptIn ch5(p17);       // aux1
//InterruptIn ch6(p18);       // aux2

void thro_up();     void roll_up();     void pitch_up();    void yaw_up();      void aux1_up();      void aux2_up();
void thro_down();   void roll_down();   void pitch_down();  void yaw_down();    void aux1_down();    void aux2_down();

Timer t_thro;       Timer t_roll;       Timer t_pitch;      Timer t_yaw;      Timer t_aux1;      Timer t_aux2;

// thro roll pitch yaw aux1 aux2
int pwm_pulse[chan]      =   {0, 0, 0, 0, 0, 0};

int main() {
    
    pc.baud(921600);
    pc.printf("hello!\r\n\r\n");
    led1 =1;
    wait(1);
    led1    =0;
    wait(1);
    led1=1;
    // Reciever function
    ch1.rise(&yaw_up);      ch1.fall(&yaw_down);
    ch2.rise(&pitch_up);    ch2.fall(&pitch_down);
    ch3.rise(&thro_up);     ch3.fall(&thro_down);
    ch4.rise(&roll_up);     ch4.fall(&roll_down);
    //ch5.rise(&aux1_up);     ch5.fall(&aux1_down);
    //ch6.rise(&aux2_up);     ch6.fall(&aux2_down);
    
    while(1) {
        
        for( int i=0;i<4;i++ ){    pc.printf("%d ", pwm_pulse[i]);  }
        pc.printf("\r\n\r\n");
        
        //ch1.enable_irq();
        //ch2.enable_irq();
        //ch3.enable_irq();
        //ch4.enable_irq();
        
        wait(.1);
        
        //ch1.disable_irq();
        //ch2.disable_irq();
        //ch3.disable_irq();
        //ch4.disable_irq();
                       
    }
}

void thro_up(){     t_thro.start();   }
void roll_up(){     t_roll.start();   }
void pitch_up(){    t_pitch.start();  }
void yaw_up(){      t_yaw.start();    }
//void aux1_up(){     t_aux1.start();   }
//void aux2_up(){     t_aux2.start();   }

void thro_down(){
    t_thro.stop();
    pwm_pulse[0]    =   (int)(t_thro.read()*1000000-1000);
    t_thro.reset();
}

void roll_down(){
    t_roll.stop();
    pwm_pulse[1]    =   (int)(t_roll.read()*1000000-1000);
    t_roll.reset();
}

void pitch_down(){
    t_pitch.stop();
    pwm_pulse[2]    =   (int)(t_pitch.read()*1000000-1000);
    t_pitch.reset();
}

void yaw_down(){
    t_yaw.stop();
    pwm_pulse[3]    =   (int)(t_yaw.read()*1000000-1000);
    t_yaw.reset();
}
/*
void aux1_down(){
    t_aux1.stop();
    pwm_pulse[4]    =   (int)(t_aux1.read()*1000000-1000);
    t_aux1.reset();
}

void aux2_down(){
    t_aux2.stop();
    pwm_pulse[5]    =   (int)(t_aux2.read()*1000000-1000);
    t_aux2.reset();
}
*/