#include "ITG3200.h"

Serial pc(USBTX, USBRX);
ITG3200 gyro(p9, p10);
      
int main() {
    
    float  t    =   0;
    float dt    =   0.1;
    double Gyro0 [3] = {0, 0, 0};
    double Gyro1 [3] = {0, 0, 0};
    double  Ang0 [3] = {0, 0, 0};
    double  Ang1 [3] = {0, 0, 0};
    
    pc.printf("Now starting ITG-3200 test\n");
    pc.printf(" Unit: Gyro[deg/s] Angle[deg]\n");
    pc.printf("  Time  GyroX  GyroY  GyroZ    AngX    AngY    AngZ\n");
    
    //Set highest bandwidth.
    gyro.setLpBandwidth(LPFBW_42HZ);
    
    //Arbitrary wait for printf clarity.
    wait(0.1);
    
    while (1) {
        //pc.printf("%x\n",gyro.getWhoAmI());
        // YAL 9DOF: x+16, y-39, z+40
        //  My 9DOF:  x, y, z
        Gyro1[0] = (gyro.getGyroX()+16)/14.375;      Gyro1[1] = (gyro.getGyroY()-39)/14.375;      Gyro1[2] = (gyro.getGyroZ()+40)/14.375;
        
        // Low pass filter for gyro
        if( -1.0<Gyro1[0] && Gyro1[0]<1.0 ){    Gyro1[0]=0;  }
        if( -1.0<Gyro1[1] && Gyro1[1]<1.0 ){    Gyro1[1]=0;  }
        if( -1.0<Gyro1[2] && Gyro1[2]<1.0 ){    Gyro1[2]=0;  }
        
        // Trapezoidal integration
        Ang1[0] = Ang0[0]+(Gyro0[0]+Gyro1[0])*dt/2;
        Ang1[1] = Ang0[1]+(Gyro0[1]+Gyro1[1])*dt/2;
        Ang1[2] = Ang0[2]+(Gyro0[2]+Gyro1[2])*dt/2;
        
        pc.printf("%6.1f, %5.0f, %5.0f, %5.0f, %6.1f, %6.1f, %6.1f\n\r", 
                  t, Gyro1[0], Gyro1[1], Gyro1[2], Ang1[0], Ang1[1], Ang1[2]);
        
        Gyro0[0] = Gyro1[0];  Gyro0[1] = Gyro1[1];  Gyro0[2] = Gyro1[2];
        Ang0[0]  = Ang1[0];   Ang0[1]  = Ang1[1];   Ang0[2]  = Ang1[2];
        t   =   t+dt;
        wait(0.1);

    }

}
