#include "mbed.h"

#define DEBUG_0_PRINT_OUT_ENABLE  1
#if DEBUG_0_PRINT_OUT_ENABLE
#define DEBUG_0(...) { printf(__VA_ARGS__); }
#else
#define DEBUG_0(...) /* nothing */
#endif /* #if DEBUG_0_PRINT_OUT_ENABLE */

#define LED_ON                      1           // LED is ACTIVE HIGH. It turns ON when the control pin is HIGH
#define LED_OFF                     0           // LED is ACTIVE HIGH. It turns OFF when the control pin is LOW
#define BUTTON_PRESSED_LED_STATE    LED_ON
#define BUTTON_RELEASED_LED_STATE   LED_OFF

DigitalOut      led1(LED1);
InterruptIn     userButton(USER_BUTTON);

bool buttonPressedInterrupt = false;
bool buttonReleasedInterrupt = false;

void 
buttonPressedCallback(void)
{
    // Flag main to handle heavy work. Heavy work should not be handle in interrupt handler
    buttonPressedInterrupt = true;
}

void
buttonReleasedCallback(void)
{
    // Flag main to handle heavy work. Heavy work should not be handle in interrupt handler
    buttonReleasedInterrupt = true;
}

void
initBoard(void)
{
    // Init LED to turn ON by default
    led1 = BUTTON_RELEASED_LED_STATE;
    // Init button pressed and released behavior
    userButton.rise(buttonReleasedCallback);    // Button is ACTIVE LOW. Released the button pull input pin HIGH, triggering the Rising Edge interrupt.
    userButton.fall(buttonPressedCallback);     // Button is ACTIVE LOW. Pressed the button pull input pin LOW, triggering the Falling Edge interrupt.
    userButton.enable_irq();
}

int 
main() 
{
    initBoard();
    
    DEBUG_0("NUCLEO_BTN_LED_DEMO started\n");
    
    led1 = LED_ON;
    wait_ms(1000);
    led1 = LED_OFF;
    wait_ms(1000);
    while(1) {
        if (buttonReleasedInterrupt)
        {
            led1 = BUTTON_RELEASED_LED_STATE;
            DEBUG_0("button released\n");
            
            buttonReleasedInterrupt = false;
        }
        
        if (buttonPressedInterrupt)
        {
            led1 = BUTTON_PRESSED_LED_STATE;
            DEBUG_0("button pressed\n");
            
            buttonPressedInterrupt = false;
        }
    }
}
