/*****************************************************************************
  BH1790GLC.cpp

 Copyright (c) 2016 ROHM Co.,Ltd.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
******************************************************************************/


#include "BH1790GLC.h"

BH1790GLC::BH1790GLC( PinName sda, PinName scl, char address )
    : i2c_p( new I2C( sda, scl ) ), i2c( *i2c_p ), adr( address )
{
    init();
}

BH1790GLC::BH1790GLC( I2C &i2c_obj, char address )
    : i2c_p( NULL ), i2c( i2c_obj ), adr( address )
{
    init();
}

BH1790GLC::~BH1790GLC()
{
    if ( NULL != i2c_p )
        delete i2c_p;
}

void BH1790GLC::init(void)
{
}

int BH1790GLC::meas_start(void)
{
    int rc;
    char val[3];
    val[0] = BH1790GLC_MEAS_CONTROL1_VAL;
    val[1] = BH1790GLC_MEAS_CONTROL2_VAL;
    val[2] = BH1790GLC_MEAS_START_VAL;
    rc = write(BH1790GLC_MEAS_CONTROL1, val, sizeof(val));
    return (rc);
}

int BH1790GLC::get_rawval(char *data)
{
    int rc;
    rc = read(BH1790GLC_DATAOUT_LEDOFF, data, 4);
    return (rc);
}

int BH1790GLC::get_val(unsigned short *data)
{
    int rc;
    char val[4];
    rc = get_rawval(val);
    data[0] = ((unsigned short)val[1] << 8) | (val[0]);
    data[1] = ((unsigned short)val[3] << 8) | (val[2]);
    return (rc);
}

int BH1790GLC::write(char memory_address, char *data, int size)
{
    int rc;
    char cmd[size];
    cmd[0] = memory_address;
    for (int i=0; i<size; i++) {
        cmd[i+1] = data[i];
    }
    rc = i2c.write( adr, cmd, size+1,true);
    return (rc);
}

int BH1790GLC::read(char memory_address, char *data, int size)
{
    int rc;
    char cmd[size];
    cmd[0] = memory_address;
    rc = i2c.write( adr, cmd, 1, false);
    if (rc !=0){
        return (rc);
    }
    rc = i2c.read ( adr, data, size);
    return (rc);
}