/*****************************************************************************
  BH1790GLC.h

 Copyright (c) 2016 ROHM Co.,Ltd.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
******************************************************************************/
#ifndef _BH1790GLC_H_
#define _BH1790GLC_H_

#define BH1790GLC_DEVICE_ADDRESS      (0x5B<<1)    
#define BH1790GLC_MID_VAL             (0xE0)
#define BH1790GLC_PID_VAL             (0x0D)

#define BH1790GLC_MANUFACTURER_ID     (0x0F)
#define BH1790GLC_PART_ID             (0x10)
#define BH1790GLC_MEAS_CONTROL1       (0x41)
#define BH1790GLC_DATAOUT_LEDOFF      (0x54)

#define BH1790GLC_MEAS_CONTROL1_RDY                     (1 << 7)
#define BH1790GLC_MEAS_CONTROL1_LED_LIGHTING_FREQ_128HZ (0 << 2)
#define BH1790GLC_MEAS_CONTROL1_RCYCLE_32HZ             (2 << 0)

#define BH1790GLC_MEAS_CONTROL2_LED_EN_00               (0 << 6)
#define BH1790GLC_MEAS_CONTROL2_LED_ON_TIME_0_3MS       (0 << 5)
#define BH1790GLC_MEAS_CONTROL2_LED_CURRENT_10MA        (12 << 0)

#define BH1790GLC_MEAS_START_MEAS_ST                    (1 << 0)

#define BH1790GLC_MEAS_CONTROL1_VAL   (BH1790GLC_MEAS_CONTROL1_RDY | BH1790GLC_MEAS_CONTROL1_LED_LIGHTING_FREQ_128HZ | BH1790GLC_MEAS_CONTROL1_RCYCLE_32HZ)
#define BH1790GLC_MEAS_CONTROL2_VAL   (BH1790GLC_MEAS_CONTROL2_LED_EN_00 | BH1790GLC_MEAS_CONTROL2_LED_ON_TIME_0_3MS | BH1790GLC_MEAS_CONTROL2_LED_CURRENT_10MA)
#define BH1790GLC_MEAS_START_VAL      (BH1790GLC_MEAS_START_MEAS_ST)

#include "mbed.h"

/** BH1790GLC class
 *
 *  BH1790GLC: an I2C bus optical sensor for heart rate monitor library
 *
 *  BH1790GLC is optical sensor for heart rate monitor IC in
 *  which LED driver and green light detection photo-diode
 *  are incorporated. This device drives LED and provides
 *  the intensity of light reflected from body.
 *
 *  For more information about BH1790GLC:
 *    http://www.rohm.com/web/global/datasheet/BH1790GLC/bh1790glc-e
 *    
 *  This was ported from Arduino library by H.Tanaka
 *    http://rohmfs.rohm.com/en/products/databook/applinote/ic/sensor/optical_sensor_for_heart_rate_monitor/bh1790glc-evk-001-manual-e.pdf
 *    http://rohmfs.rohm.com/en/products/databook/applinote/ic/sensor/optical_sensor_for_heart_rate_monitor/bh1790glc-software-manual-e.pdf
 */

class BH1790GLC
{
public:
    /** Create a BH1790GLC instance connected to specified I2C pins with specified address
     *
     * @param sda I2C-bus SDA pin
     * @param scl I2C-bus SCL pin
     * @param i2c_address I2C-bus address (default: 0x5B<<1)
     */
    BH1790GLC(PinName sda, PinName scl, char address = BH1790GLC_DEVICE_ADDRESS);
    /** Create a BH1790GLC instance connected to specified I2C object with specified address
    *
    * @param i2c_obj I2C object (instance)
    * @param i2c_address I2C-bus address (default: 0x5B<<1)
    */
    BH1790GLC(I2C &i2c_obj, char address = BH1790GLC_DEVICE_ADDRESS);
    /** Destructor of BH1790GLC
     */
    ~BH1790GLC();

    void init(void);
    int meas_start(void);
    int get_rawval(char *data);
    int get_val(unsigned short *data);
    int write(char memory_address,char *data,int size);
    int read(char memory_address,char *data, int size);
private:
    I2C *i2c_p;
    I2C &i2c;
    char adr;
};
#endif