#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"
Serial pc(USBTX, USBRX);
InterruptIn but1(PTC6);

BiQuad bq1 (0.881889334678067,  -1.76377866935613,   0.8818893346780671,  -1.77069673005903,   0.797707797506027);

BiQuad bq2 (0.000198358203463849,    0.000396716406927699,    0.000198358203463849, -1.96262073248799,   0.963423352820821);


BiQuadChain bqc;


//Define objects
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

Ticker      sample_timer;
Ticker      calibration_timer;
HIDScope    scope( 3 );
DigitalOut  led(LED2);

/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
float filter_value;
float emg0_value;
float emg1_value;
float filter_max;
float filter_min;

void sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    emg0_value = emg0.read();
    emg1_value = emg1.read();


    filter_value = fabs(bq2.step(fabs(bq1.step(emg0_value-emg1_value))));

    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
    scope.set(2, filter_value);

    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels)
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */

    scope.send();

    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}

void sample_2()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    emg0_value = emg0.read();
    emg1_value = emg1.read();


    filter_value = fabs(bq2.step(fabs(bq1.step(emg0_value-emg1_value))));
    filter_value = (filter_value-filter_min) / (0.5*filter_max-filter_min);
    
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
    scope.set(2, filter_value);

    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels)
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */

    scope.send();

    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}


const int length = 1000;
int i;
float sample_array[length] = {};

void calibration()
{
    i = 0;
    while (i < (length)) {
        sample();
        pc.printf("I can reach this point\r\n");
        sample_array[i] = filter_value;
        pc.printf("The filter_value is %f\r\n",filter_value);
        i++;
        wait(0.001);
    }

    filter_max = -100.0;
    filter_min = 100.0;
    int m;
    for (m = 200 ; m < length ; m++) {
        pc.printf("the value of the m-st instance of sample_array is %f\r\n",sample_array[m]);
        if (sample_array[m] > filter_max) {
            filter_max = sample_array[m];
        }
        if (sample_array[m] < filter_min) {
            filter_min = sample_array[m];
            }
    }
    pc.printf("The value of filter_max is %f\r\nThe value of filter_min is %f\r\n",filter_max, filter_min);
}

int main()
{
    pc.baud(115200);
    pc.printf("Running main");
    bqc.add( &bq1);
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    wait(2);
    calibration();

    sample_timer.attach(&sample_2, 0.001);

    /*empty loop, sample() is executed periodically*/
    while(1) {}
}
