#include "mbed.h"
#include "LSM303DLH.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);


/*
    Misc decl.
*/
Serial debug(USBTX,USBRX);


/*
    Motor Declarations and functions
    @param on : decidedes which bits to set from the forward and backward array 
*/

unsigned int on = 0;

DigitalOut m1(p21);
DigitalOut m2(p22);
DigitalOut m3(p23);
DigitalOut m4(p24);

enum control{
    forward,
    backward
}stepper_direction = forward;

float motorTimeLapsed = 0.0, degrees = 0, motorTimerFrequency = 0.007, oneRotationTime = 15.0;

char* forwardArr[] = {"1000", "1100", "0100", "0110","0010", "0011","0001", "1001"};
char* backwardArr[] = {"1000", "1001", "0001", "0011", "0010", "0110", "0100", "1100"};


void SetPortValues(char *myValues){
    m1 = myValues[0] - 48;
    m2 = myValues[1] - 48;
    m3 = myValues[2] - 48;
    m4 = myValues[3] - 48;
}


void attime() {
    motorTimeLapsed += motorTimerFrequency;
    if(motorTimeLapsed > oneRotationTime){ 
        motorTimeLapsed = 0;
        stepper_direction = stepper_direction == forward?backward:forward; 
    }
    stepper_direction?SetPortValues(backwardArr[++on%8]):SetPortValues(forwardArr[++on%8]);
    degrees = (stepper_direction == forward)?(motorTimeLapsed/oneRotationTime*180.0):(180.0-(motorTimeLapsed/oneRotationTime*180.0));
}

/*
    Sonar - decl and functions
*/

long duration, distance_cm;
Timer timerSonar; 
DigitalOut trig(p6); // To generate trigger for Sonar
InterruptIn echo(p5); // To capture echo edge on I/O interrupt

void begin_timer(){
    timerSonar.reset();  //reset timer
    timerSonar.start();
}

void end_timer()
{
    timerSonar.stop();
    duration =  timerSonar.read_us(); // Pulse width measured
    distance_cm = (double)(duration/2)*0.034  ; 
}

void echo_duration() {
        trig=0;   // trigger low 
        wait_us(2); //  wait 
        trig=1;   //  trigger high
        wait_us(10);
        trig=0;  // trigger low
}

/*
    Magnetometer decl and functions
*/

LSM303DLH compass(p9, p10);


int main() { 
    //configure motor
    Ticker motorTimer;
    motorTimer.attach(&attime, motorTimerFrequency);
    //configure sonar
    echo.rise(&begin_timer);
    echo.fall(&end_timer);
    //configure compass
    float hdg;
    compass.setOffset(29.50, -0.50, 4.00);
    compass.setScale(1.00, 1.03, 1.21);
    while(1) {
        echo_duration();
        hdg = compass.heading((vector){0,-1,0});
        debug.printf("Degree = %f Distance = %d Heading: %.2f \n\r", degrees, distance_cm, hdg);
    }
}
