# ARM mbed OS
 
mbed OS is an open-source embedded operating system designed for the "things" in the Internet of Things (IoT). mbed OS includes the features you need to develop a connected product using an ARM Cortex-M microcontroller.
 
mbed OS provides a platform that includes:
 - Security foundations.
 - Cloud management services.
 - Drivers for sensors, I/O devices and connectivity.

mbed OS is modular, configurable software that you can customize it to your device and to reduce memory requirements by excluding unused software.

 
## Release Notes

The [Release Notes](https://docs.mbed.com/docs/mbed-os-release-notes/en/latest/) detail the current release and previous versions.

## Continuous Integration Status

We run continuous integration on all of our branches and pull requests to verify the stability of mbed OS. The following are the Travis CI indicators for mbed OS.

 - Master branch [![Master Branch CI Badge](https://travis-ci.org/ARMmbed/mbed-os.svg?branch=master)](https://travis-ci.org/ARMmbed/mbed-os)
 - Latest release [![Latest Tag CI Badge](https://travis-ci.org/ARMmbed/mbed-os.svg?branch=latest)](https://travis-ci.org/ARMmbed/mbed-os/branches)

Tools coverage [![Coverage Status](https://coveralls.io/repos/github/ARMmbed/mbed-os/badge.svg?branch=master)](https://coveralls.io/github/ARMmbed/mbed-os?branch=master)

## Getting Started for Developers
 
You need [mbed CLI](https://github.com/ARMmbed/mbed-cli) to build mbed OS. For more details, read the [mbed OS Handbook](https://docs.mbed.com/docs/mbed-os-handbook/en/latest/).

## Getting Started for Contributors
 
We have a [Contributing and Publishing Guide](https://docs.mbed.com/docs/mbed-os-handbook/en/latest/cont/contributing/) in the mbed OS Handbook.
