//#define RASPBERRY_PI_CAN_ADDRESS  0x01
#define YODA2
#define RASPBERRY_PI_CAN_TYPE   0x07
#define RASPBERRY_PI_CAN_ID     0x01
#define RASPBERRY_PI_CAN_ADDRESS    ((RASPBERRY_PI_CAN_TYPE<<8) | RASPBERRY_PI_CAN_ID)

#ifdef OWN_SOLDER_BOARD
#define BUTTON1 PB_4        // right // up
#define BUTTON2 PC_1        // left  // down
#define BUTTON3 PC_7        // enter    // next
#define BUTTON4 PA_9        // menu     // back
#endif

#ifdef YODA2
#define BUTTON1 PA_8        // right // up
#define BUTTON2 PB_10        // left  // down
#define BUTTON3 PB_4        // enter    // next
#define BUTTON4 PB_5        // menu     // back
#define RELAY_4 PD_2 
#define RELAY_3 PC_11
#define RELAY_2 PC_10
#define RELAY_1 PC_12
#endif

#define BUTTON1_HOLD_EVENT         0x0001
#define BUTTON1_PRESSED_EVENT       0x0002
#define BUTTON2_HOLD_EVENT         0x0004
#define BUTTON2_PRESSED_EVENT       0x0008
#define BUTTON3_HOLD_EVENT         0x0010
#define BUTTON3_PRESSED_EVENT       0x0020
#define BUTTON4_HOLD_EVENT         0x0040
#define BUTTON4_PRESSED_EVENT       0x0080
#define NEXT_HOLD_EVENT          BUTTON4_HOLD_EVENT
#define NEXT_PRESSED_EVENT       BUTTON4_PRESSED_EVENT
#define BACK_HOLD_EVENT         BUTTON3_HOLD_EVENT
#define BACK_PRESSED_EVENT      BUTTON3_PRESSED_EVENT
#define DOWN_HOLD_EVENT          BUTTON2_HOLD_EVENT
#define DOWN_PRESSED_EVENT       BUTTON2_PRESSED_EVENT
#define UP_HOLD_EVENT         BUTTON1_HOLD_EVENT
#define UP_PRESSED_EVENT      BUTTON1_PRESSED_EVENT
#define LCD_DISPLAY_HOLD_EVENT      0x0001
#define LCD_DISPLAY_RELEASE_EVENT   0x0002

#define COMMAND_INIT  0 // all the devices return to the point 0 and return the current possition or current weight
#define COMMAND_PLUS  1 // for the devices to plus weight return the weight
#define COMMAND_MINUS 2 // for the devices to minus weight return the weight
#define COMMAND_MOVE_ABSOLUTE 3 // for the devices to move to the absolute position return the current absolute position
#define COMMAND_MOVE_RELATIVE 4 // for the devices to move relative distance return the current absolute position
#define COMMAND_REPORT_WEIGHT 5 // for the devices to report the current weight 
#define COMMAND_REPORT_POSITION 6 // for the devices to report the current absolute position
#define COMMAND_CLEAN 7 // for the devices to clean the cups return done or failed
#define COMMAND_TARE 8  // for the devices to tare the scale return done or failed
#define COMMAND_SHAKE_CUP 9 // for the device to shake the cups return done or failed
#define COMMAND_POUR_TEA 10 // for the device to pour the tea return done or failed
#define COMMAND_FINISH 11   // for everything finished return done or failed
#define COMMAND_RESET 12    // for the devices return to the point 0 and clean themselvies
#define COMMAND_REGISTER 13 // for device to register itself to raspberry pi


#define WEIGHT_DIFFERENCE   200   // 10g ADC value minimum difference
#define CALIBRATION_WEIGHT  2000    // calibration weight
#define MAXIMUM_CALIBRATION_WEIGHT  5000 
#define MINIMUM_CALIBRATION_WEIGHT  100 

#ifdef OWN_SOLDER_BOARD
#define EEPROM_ADDR 0x0   // I2c EEPROM address is 0x00
#endif
#ifdef YODA2
#define EEPROM_ADDR 0x57   
#endif
#ifdef STM32F207xx
#define SDA PB_9            // I2C SDA pin
#define SCL PB_8           // I2C SCL pin
#endif

#ifdef STM32F303xE
#ifdef OWN_SOLDER_BOARD
#define SDA PC_9//D2//D2//PB_9 //PF_0            // I2C SDA pin
#define SCL D7//D8//D8//PB_8 //PF_1           // I2C SCL pin
#endif
#ifdef YODA2
#define SDA PA_10//D2//D2//PB_9 //PF_0            // I2C SDA pin
#define SCL PA_9//D8//D8//PB_8 //PF_1           // I2C SCL pin
#define LCD_SDA PB_9            // I2C SDA pin
#define LCD_SCL PB_8           // I2C SCL pin
#define SCALE_SDA PA_1
#define SCALE_SCL PA_0
#define SCALE2_SDA PF_1
#define SCALE2_SCL PA_0
#define CAN_RD PA_11
#define CAN_TD PA_12
#define DIN1    PC_0
#define DIN2    PC_1
#define DIN3    PB_0
#define DIN4    PA_4
#define DIN5    PC_3
#define DIN6    PC_2
#define DIN7    PB_7
#define DIN8    PA_15
#endif
#endif
 
#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#define MAX(X,Y) ((X) > (Y) ? (X) : (Y))

#define EEPROM_DEVICE_ADDRESS_ADDRESS  0x40
#define DEVICE_DEFAULT_ADDRESS   12


enum Device_Type_d
{
    CupTrack=0,
    JamTrack=1,
    TeaTrack=2,
    Tea=3,
    Jam=4,
    Shaker=5, 
    IceMaker=6
};


struct ScaleCalibrationData {
  unsigned int calibrationWeight;  // the weight (g) used for calibration for example 1000g or 10g. The maximum value is 3000. 
  long offsetValue;       // the value for scale offset
  float scaleValue;       // the ADC increment for 1g  
  uint8_t checksum;  
};

// because memcpy is 16 byte alignment no byte in struct
struct data_field_d {
    uint16_t cmd;
    uint16_t value1;
    uint16_t value2;
    uint16_t value3;
};
