#include "mbed.h"
#include <HX711.h>
#include <eeprom.h>
#include <SB1602E.h>
#include "yoda2.h"
#include "eeprom_cust.h"
#include <string.h>
#include "TextLCD.h"
#if 1
enum menu_status_d{
    MENU_IDLE=0,
    MENU_SCALE_TARE=1,
    MENU_CHANGE_CALIBRATION_WEIGHT=2,
    MENU_CALIBRATIOIN=3,
    MENU_ADDRESS_TYPE=4,
    MENU_ADDRESS=5,
    MENU_RESET=6,
    MENU_SUBMENU1,
    MENU_SUBMENU2
} ;
menu_status_d menu_status = MENU_IDLE;
enum submenu_status_d{
    SUBMENU_0=0,
    SUBMENU_1=1,
    SUBMENU_2=2,
    SUBMENU_3=3,
    SUBMENU_4=4
};

submenu_status_d submenu_status = SUBMENU_0;

Device_Type_d device_type_v;
string device_type_string[]=
{
   "CupTrack",
   "JamTrack",
   "TeaTrack",
   "Tea",
   "Jam",
   "Shaker"
};

extern EventFlags button_event_flags;
extern EventFlags LCD_update_flags;
extern int device_address;  // last 8 bits of address
extern int device_type; // first 3 bits of adddress
extern ScaleCalibrationData customVar;
#ifdef STM32F303xE
#ifdef LCD_1602
extern SB1602E lcd;  //  SDA, SCL
#endif
#ifdef YODA2
extern TextLCD_I2C_N lcd;
#endif
#endif
extern HX711 hx711; // scale
extern EEPROM ep;
extern void scaleCalibration(bool release_led);
extern int change_calibrationWeight(unsigned int new_weight);
int size_of_array = 0;

void main_menu()
{
    uint32_t flags_read = 0;
    int temp_address = (device_address & 0xFF);
    int temp_type = device_type;
    unsigned int temp_calibration_weight=customVar.calibrationWeight;
    int previous_event = 0;
    float waiting_time = 0.3;
    bool ignore_UP_DOWN_pressed_event = false;
    int temp_value;
    
    printf("main_menu\r\n");

    temp_value = sizeof(device_type_string);
//    printf("total bytes = %d\r\n", temp_value);    
    while(1)
    {
        temp_value = temp_value - sizeof(device_type_string[size_of_array]);
        size_of_array++;
//        printf("temp_value= %d size_of_array=%d\r\n", temp_value, size_of_array);        
        if (temp_value <= 0)
            break;     
    }

    while (1) {
        if (menu_status == MENU_IDLE)
            flags_read = button_event_flags.wait_any(0xFF);
        else
            flags_read = button_event_flags.wait_any(0xFF, 1);
        if (flags_read != 0xfffffffe)
            printf("Got: 0x%08lx menu_status=%d\r\n", flags_read, menu_status);      
        switch(flags_read)
        {
            case NEXT_HOLD_EVENT:
            case BACK_HOLD_EVENT:  
            case DOWN_HOLD_EVENT:
            case UP_HOLD_EVENT:
                previous_event = flags_read;
                waiting_time = 0.3;              
                break;
            case NEXT_PRESSED_EVENT:
            case BACK_PRESSED_EVENT:  
            case DOWN_PRESSED_EVENT:
            case UP_PRESSED_EVENT:
                previous_event = 0;
                waiting_time = 0.3;
                break;
            default:
                flags_read = previous_event;
                break;
        }
        switch(flags_read)
        {
            case NEXT_PRESSED_EVENT:
                switch (menu_status) 
                {
                    case MENU_IDLE:    
                        submenu_status = SUBMENU_0;       
                        LCD_update_flags.set(LCD_DISPLAY_HOLD_EVENT);
                        wait(0.5);
#ifdef LCD_1602                        
                        lcd.clear();
#endif  
#ifdef YODA2
                        lcd.cls();
#endif                      
                        switch (device_type_v)
                        {
                            case Tea:
                            case Jam:
#ifdef LCD_1602                            
                                lcd.printf(0, 0, "1.TARE the scale"); 
                                lcd.printf(0, 1, "Tare");
#endif 
#ifdef YODA2
                                lcd.setAddress(0,0);
                                lcd.printf("1.TARE the scale"); 
                                lcd.setAddress(0,1);
                                lcd.printf("Tare");
#endif                                
                                menu_status = MENU_SCALE_TARE;
                                break;
                            default:
#ifdef LCD_1602                            
                                lcd.printf(0, 0, "4.Device Type"); 
#endif                       
#ifdef YODA2
                                lcd.setAddress(0,0);
                                lcd.printf("4.Device Type"); 
#endif           
                                if ((device_type >= 0) && (device_type < size_of_array))
                                {
#ifdef LCD_1602                                    
                                    lcd.printf(0, 1, "%s ", device_type_string[device_type]);
#endif                                    
#ifdef YODA2
                                lcd.setAddress(0,1);
                                lcd.printf("%s ", device_type_string[device_type]); 
#endif 
                                }
                                menu_status = MENU_ADDRESS_TYPE;                                                      
                                break;        
                        }  // end of  switch (device_type_v)                    
                        break;
                    case MENU_SCALE_TARE:
                        if (submenu_status != SUBMENU_0)
                        {
                            hx711.tare(5);
#ifdef LCD_1602                        
                            lcd.printf(0, 1, "Done");
#endif   
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("Done"); 
#endif     
                            wait(0.5);
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("Tare"); 
                            lcd.setCursor(TextLCD::CurOff_BlkOff);                            
#endif                               
                            submenu_status = SUBMENU_0;
                            menu_status = MENU_SCALE_TARE;
                        }
                        else
                        {
#ifdef LCD_1602                    
                            lcd.clear();
                            lcd.printf(0, 0, "2.CaliWeight(g)"); 
                            lcd.printf(0, 1, "%d", customVar.calibrationWeight);
#endif         
#ifdef YODA2
                            lcd.cls();
                            lcd.setAddress(0,0);
                            lcd.printf("2.CaliWeight(g)"); 
                            lcd.setAddress(0,1);
                            lcd.printf("%d", customVar.calibrationWeight); 
#endif                
                            menu_status = MENU_CHANGE_CALIBRATION_WEIGHT;
                        }
                        break;
                    case MENU_CHANGE_CALIBRATION_WEIGHT:
                        if (submenu_status != SUBMENU_0)
                        {
                            change_calibrationWeight(temp_calibration_weight);
#ifdef LCD_1602                        
                            lcd.clear();
                            lcd.printf(0, 0, "2.Calibration Weight"); 
                            lcd.printf(0, 1, "Saved");
#endif  
#ifdef YODA2
                            lcd.setAddress(0,0);
                            lcd.printf("2.Calibration Weight"); 
                            lcd.setAddress(0,1);
                            lcd.printf("Saved"); 
#endif             
                            wait(0.5);
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("       ");
                            lcd.setAddress(0,1);
                            lcd.printf("%d", customVar.calibrationWeight);
#endif   
                            submenu_status = SUBMENU_0;
                            menu_status = MENU_CHANGE_CALIBRATION_WEIGHT;
                            lcd.setCursor(TextLCD::CurOff_BlkOff);
                        }
                        else
                        {
    #ifdef LCD_1602                    
                            lcd.clear();
                            lcd.printf(0, 0, "3.Do Calibration"); 
                            lcd.printf(0, 1, "Start");
    #endif    
    #ifdef YODA2
                            lcd.cls();
                            lcd.setAddress(0,0);
                            lcd.printf("3.Do Calibration"); 
                            lcd.setAddress(0,1);
                            lcd.printf("Start"); 
    #endif                     
                            menu_status = MENU_CALIBRATIOIN;
                        }
                        break;
                    case MENU_CALIBRATIOIN:
                        if (submenu_status != SUBMENU_0) 
                        {   
                            scaleCalibration(false);
#ifdef LCD_1602                        
                            lcd.clear();
                            lcd.printf(0, 0, "3.Do Calibration"); 
                            lcd.printf(0, 1, "Done");
#endif     
#ifdef YODA2
                            lcd.cls();
                            lcd.setAddress(0,0);
                            lcd.printf("3.Do Calibration"); 
                            lcd.setAddress(0,1);
                            lcd.printf("Done"); 
#endif         
                            wait(0.5);
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("Start");
#endif   
                            submenu_status = SUBMENU_0;
                            menu_status = MENU_CALIBRATIOIN;
                            lcd.setCursor(TextLCD::CurOff_BlkOff);                            
                        }
                        else
                        {           
#ifdef LCD_1602                    
                            lcd.clear();
                            lcd.printf(0, 0, "4.Device Type"); 
#endif      
#ifdef YODA2
                            lcd.cls();
                            lcd.setAddress(0,0);
                            lcd.printf("4.Device Type"); 
#endif                      
                            if ((device_type >= 0) && (device_type < size_of_array))
                            {
#ifdef LCD_1602                            
                                lcd.printf(0, 1, "%s ", device_type_string[device_type]);
#endif       
#ifdef YODA2
                                lcd.setAddress(0,1);
                                lcd.printf("%s ", device_type_string[device_type]); 
#endif                             
                            }
                            menu_status = MENU_ADDRESS_TYPE;
                        }
                        break;
                    case MENU_ADDRESS_TYPE:
                        if (submenu_status != SUBMENU_0) 
                        {
                            device_type = temp_type;
                            printf("device_address = 0x%08x \r\n", device_address);
                            ep.write((uint32_t)EEPROM_DEVICE_ADDRESS_ADDRESS, ((device_type<< 8)|(device_address & 0xFF)));
#ifdef LCD_1602                        
                            lcd.printf(0, 1, "          ");
                            lcd.printf(0, 1, "Saved");
#endif             
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("          "); 
                            lcd.setAddress(0,1);
                            lcd.printf("Saved"); 
#endif         
                            wait(0.5);
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("      "); 
                            lcd.setAddress(0,1);
                            lcd.printf("%s ", device_type_string[device_type]); 
#endif   
                            submenu_status = SUBMENU_0;
                            menu_status = MENU_ADDRESS_TYPE;
                            lcd.setCursor(TextLCD::CurOff_BlkOff);                             
                        }
                        else
                        {
#ifdef LCD_1602                    
                            lcd.clear();
                            lcd.printf(0, 0, "5.Address"); 
                            lcd.printf(0, 1, "%d ", device_address);
#endif    
#ifdef YODA2
                            lcd.cls();
                            lcd.setAddress(0,0);
                            lcd.printf("5.Address"); 
                            lcd.setAddress(0,1);
                            lcd.printf("%d ", device_address); 
#endif                     
                            menu_status = MENU_ADDRESS;
                        }
                        break;        
                    case MENU_ADDRESS:
                        if (submenu_status != SUBMENU_0) 
                        {
                            // save the address
                            device_address = temp_address;
                            ep.write((uint32_t)EEPROM_DEVICE_ADDRESS_ADDRESS, ((device_type<< 8)|(device_address & 0xFF)));
#ifdef LCD_1602                        
                            lcd.printf(0, 1, "Saved");
#endif      
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("Saved"); 
#endif  
                            wait(0.5);
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("      "); 
                            lcd.setAddress(0,1);
                            lcd.printf("%d ", device_address); 
#endif   
                            submenu_status = SUBMENU_0;
                            menu_status = MENU_ADDRESS;
                            lcd.setCursor(TextLCD::CurOff_BlkOff); 
                        }
                        else
                        {
#ifdef LCD_1602                    
                            lcd.clear();
                            lcd.printf(0, 0, "6.SoftReset"); 
                            lcd.printf(0, 1, "Reset");
#endif    
#ifdef YODA2
                            lcd.cls();
                            lcd.setAddress(0,0);
                            lcd.printf("6.SoftReset"); 
                            lcd.setAddress(0,1);
                            lcd.printf("Reset"); 
#endif                     
                            menu_status = MENU_RESET;
                        }
                        break;       
                    case MENU_RESET:
                         if (submenu_status != SUBMENU_0) 
                        {
#ifdef LCD_1602                    
                            lcd.printf(0, 1, "Resetting");
#endif  
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("Resetting"); 
#endif                        
                            submenu_status = SUBMENU_0;
                            menu_status = MENU_RESET;
                            wait(1);
                            NVIC_SystemReset();
                        }
                        else
                        {
#ifdef LCD_1602                    
                            lcd.clear();
#endif      
#ifdef YODA2
                            lcd.cls();
#endif                    
                            LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);
                            menu_status = MENU_IDLE;
                        }                   
                        break;                                                        
                    default:
#ifdef LCD_1602                    
                        lcd.clear();
#endif      
#ifdef YODA2
                        lcd.cls();
#endif                    
                        LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);
                        menu_status = MENU_IDLE;
                        break;
                }
                printf("menu_status=%d \r\n", menu_status);
                break;
            case BACK_PRESSED_EVENT:
#ifdef YODA2                            
                lcd.setCursor(TextLCD::CurOff_BlkOff);
#endif             
                switch (menu_status) 
                {
                    case MENU_IDLE:       
                        break;
                    case MENU_SCALE_TARE:
                        if (submenu_status != SUBMENU_0)
                        {
                            submenu_status =  SUBMENU_0;
                            menu_status = MENU_SCALE_TARE;
                        }  
                        else
                        {    
#ifdef YODA2
                            lcd.cls();
#endif                    
                            LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);
                            menu_status = MENU_IDLE;                            
                        }                
                        break;
                    case MENU_CHANGE_CALIBRATION_WEIGHT:
                        if (submenu_status != SUBMENU_0)
                        {
                            submenu_status =  SUBMENU_0;
                            menu_status = MENU_CHANGE_CALIBRATION_WEIGHT;
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("       ");
                            lcd.setAddress(0,1);
                            lcd.printf("%d", customVar.calibrationWeight);
#endif                              
                        }  
                        else
                        {    
#ifdef YODA2
                            lcd.cls();
#endif                    
                            LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);
                            menu_status = MENU_IDLE;                            
                        }                         
                        break;
                    case MENU_CALIBRATIOIN:
                         if (submenu_status != SUBMENU_0)
                        {
                            submenu_status =  SUBMENU_0;
                            menu_status = MENU_CHANGE_CALIBRATION_WEIGHT;
                        }  
                        else
                        {    
#ifdef YODA2
                            lcd.cls();
#endif                    
                            LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);
                            menu_status = MENU_IDLE;                            
                        }                     
                        break;                        
                    case MENU_ADDRESS_TYPE:
                        if (submenu_status != SUBMENU_0)
                        {
                            submenu_status =  SUBMENU_0;
                            menu_status = MENU_ADDRESS_TYPE;
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("        "); 
                            lcd.setAddress(0,1);
                            lcd.printf("%s ", device_type_string[device_type]); 
#endif                         
                        }  
                        else
                        {    
#ifdef YODA2
                            lcd.cls();
#endif                    
                            LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);
                            menu_status = MENU_IDLE;                            
                        }             
                        break;                                                
                    case MENU_ADDRESS:
                        if (submenu_status != SUBMENU_0)
                        {
                            submenu_status =  SUBMENU_0;
                            menu_status = MENU_ADDRESS;
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("        "); 
                            lcd.setAddress(0,1);
                            lcd.printf("%d ", device_address); 
#endif                              
                        }  
                        else
                        {    
#ifdef YODA2
                            lcd.cls();
#endif                    
                            LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);
                            menu_status = MENU_IDLE;                            
                        }                  
                        break;
                    case MENU_RESET:
                        if (submenu_status != SUBMENU_0)
                        {
                            submenu_status =  SUBMENU_0;
                            menu_status = MENU_RESET;
                        }  
                        else
                        {    
#ifdef YODA2
                            lcd.cls();
#endif                    
                            LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);
                            menu_status = MENU_IDLE;                            
                        } 
                        break;
                    default:
                        break;
                }
                break;               
            case DOWN_PRESSED_EVENT:
                switch (menu_status) 
                {
                    case MENU_IDLE:           
                        break;
                    case MENU_CHANGE_CALIBRATION_WEIGHT:
                        if (submenu_status == SUBMENU_0)
                        {
 #ifdef YODA2                        
                            lcd.setAddress(0,1);    
                            lcd.setCursor(TextLCD::CurOn_BlkOn);
#endif                             
                            submenu_status = SUBMENU_1;
                        }
                        else
                        {
                            if (ignore_UP_DOWN_pressed_event)
                            {
                                ignore_UP_DOWN_pressed_event = false;
                            }
                            else
                            {
                                if (temp_calibration_weight > 1000)
                                    temp_calibration_weight -= 1000;
                                else
                                    temp_calibration_weight = 1000;
    #ifdef LCD_1602    
                                lcd.printf(0, 1, "        ");    //  line# (0 or 1), string
                                lcd.printf(0, 1, "%d ", temp_calibration_weight);    //  line# (0 or 1), string
    #endif        
    #ifdef YODA2
                                lcd.setAddress(0,1);
                                lcd.printf("        "); 
                                lcd.setAddress(0,1);
                                lcd.printf("%d ", temp_calibration_weight);  
                                lcd.setAddress(0,1);                            
    #endif                    
                            }   
                        }                 
                        break;                         
                    case MENU_ADDRESS_TYPE:
                        if (submenu_status == SUBMENU_0)
                        {
                            submenu_status = SUBMENU_1;
#ifdef YODA2                        
                            lcd.setAddress(0,1);    
                            lcd.setCursor(TextLCD::CurOn_BlkOn);
#endif                            
                        }  
                        else
                        {                    
                            if (ignore_UP_DOWN_pressed_event)
                            {
                                ignore_UP_DOWN_pressed_event = false;
                            }
                            else
                            {
                                if (temp_type > 0)
                                    temp_type--;
                                else
                                    if (temp_type == 0)
                                        temp_type = size_of_array - 1;
#ifdef LCD_1602     
                                lcd.printf(0, 1, "        ");    //  line# (0 or 1), string
                                lcd.printf(0, 1, "%s ", device_type_string[temp_type]);    //  line# (0 or 1), string
#endif     
#ifdef YODA2
                                lcd.setAddress(0,1);
                                lcd.printf("        "); 
                                lcd.setAddress(0,1);
                                lcd.printf("%s ", device_type_string[temp_type]);    
                                lcd.setAddress(0,1);                           
#endif                         
                            }  
                        }                  
                        break;
                    case MENU_ADDRESS:
                        if (submenu_status == SUBMENU_0)
                        {
                            submenu_status = SUBMENU_1;
#ifdef YODA2                        
                            lcd.setAddress(0,1);    
                            lcd.setCursor(TextLCD::CurOn_BlkOn);
#endif                            
                        } 
                        else
                        {                    
                            // save the address
                            if (ignore_UP_DOWN_pressed_event)
                            {
                                ignore_UP_DOWN_pressed_event = false;
                            }
                            else
                            {
                                if (temp_address > 1)
                                    temp_address--;
#ifdef LCD_1602     
                                lcd.printf(0, 1, "        ");    //  line# (0 or 1), string
                                lcd.printf(0, 1, "%d ", temp_address);    //  line# (0 or 1), string
#endif  
#ifdef YODA2
                                lcd.setAddress(0,1);
                                lcd.printf("        "); 
                                lcd.setAddress(0,1);
                                lcd.printf("%d ", temp_address);    
                                lcd.setAddress(0,1);                         
#endif                          
                            }
                        }
                        break;
                    default:
                        if (submenu_status == SUBMENU_0)
                        {
                            submenu_status = SUBMENU_1;
#ifdef YODA2                        
                            lcd.setAddress(0,1);    
                            lcd.setCursor(TextLCD::CurOn_BlkOn);
#endif                            
                        }                     
                        break;
                }
                break;                     
           case DOWN_HOLD_EVENT:
                switch (menu_status) 
                {
                    case MENU_IDLE:           
                        break;                                
                    case MENU_ADDRESS:
                        if (submenu_status != SUBMENU_0)
                        {
                            // save the address
                            ignore_UP_DOWN_pressed_event = true;
                            if (waiting_time > 0)
                            {
                                wait(waiting_time);
                                waiting_time -= 0.05;
                            }
                            else
                                waiting_time = 0;
                            if (temp_address > 1)
                                temp_address--;
#ifdef LCD_1602
                            lcd.printf(0, 1, "        ");    //  line# (0 or 1), string
                            lcd.printf(0, 1, "%d ", temp_address);    //  line# (0 or 1), string
#endif                   
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("        "); 
                            lcd.setAddress(0,1);
                            lcd.printf("%d ", temp_address);   
                            lcd.setAddress(0,1);                          
#endif      
                        }
                        break;
                    default:
                        break;
                }
                break;                                     
            case UP_PRESSED_EVENT:
                switch (menu_status) 
                {
                    case MENU_IDLE:           
                        break;
                    case MENU_CHANGE_CALIBRATION_WEIGHT:
                        
                        if (submenu_status != SUBMENU_0)
                        {
                            if (ignore_UP_DOWN_pressed_event)
                            {
                                ignore_UP_DOWN_pressed_event = false;
                            }
                            else
                            {
                                if (temp_calibration_weight < 5000)
                                    temp_calibration_weight += 1000;
                                else
                                    temp_calibration_weight = 5000;
#ifdef LCD_1602     
                                lcd.printf(0, 1, "        ");    //  line# (0 or 1), string
                                lcd.printf(0, 1, "%d ", temp_calibration_weight);    //  line# (0 or 1), string
#endif  
#ifdef YODA2
                                lcd.setAddress(0,1);
                                lcd.printf("        "); 
                                lcd.setAddress(0,1);
                                lcd.printf("%d ", temp_calibration_weight);  
                                lcd.setAddress(0,1);                           
#endif                              
                            }       
                        }             
                        break;                                 
                    case MENU_ADDRESS_TYPE:
                        if (submenu_status != SUBMENU_0)
                        {
                            if (ignore_UP_DOWN_pressed_event)
                            {
                                ignore_UP_DOWN_pressed_event = false;
                            }
                            else
                            {
                                if (temp_type < (size_of_array - 1))
                                    temp_type++;
                                else
                                    if (temp_type == (size_of_array - 1))
                                        temp_type = 0;
#ifdef LCD_1602     
                                lcd.printf(0, 1, "        ");    //  line# (0 or 1), string
                                lcd.printf(0, 1, "%s ", device_type_string[temp_type]);    //  line# (0 or 1), string
#endif  
#ifdef YODA2
                                lcd.setAddress(0,1);
                                lcd.printf("        "); 
                                lcd.setAddress(0,1);
                                lcd.printf("%s ", device_type_string[temp_type]);  
                                lcd.setAddress(0,1);                           
#endif                           
                            }         
                        }           
                        break;                        
                    case MENU_ADDRESS:
                        if (submenu_status != SUBMENU_0)
                        {
                            // save the address
                            if (ignore_UP_DOWN_pressed_event)                        
                            {
                                ignore_UP_DOWN_pressed_event = false;
                            }
                            else
                            {
                                if (temp_address < 255)
                                    temp_address++;
#ifdef LCD_1602
                                lcd.printf(0, 1, "        ");    //  line# (0 or 1), string
                                lcd.printf(0, 1, "%d ", temp_address);    //  line# (0 or 1), string
#endif       
#ifdef YODA2
                                lcd.setAddress(0,1);
                                lcd.printf("        "); 
                                lcd.setAddress(0,1);
                                lcd.printf("%d ", temp_address);   
                                lcd.setAddress(0,1);                          
#endif                       
                            }
                        }
                        break;
                    default:
                        if (submenu_status != SUBMENU_0)
                        {
                            submenu_status = SUBMENU_0;
#ifdef YODA2                            
                            lcd.setCursor(TextLCD::CurOff_BlkOff);
#endif                      
                        }
                        break;
                }
                break;  
          case UP_HOLD_EVENT:
                switch (menu_status) 
                {
                    case MENU_IDLE:           
                        break;
                    case MENU_ADDRESS:
                        if (submenu_status != SUBMENU_0)
                        {
                            ignore_UP_DOWN_pressed_event = true;                    
                            if (waiting_time > 0)
                            {
                                wait(waiting_time);
                                waiting_time -= 0.05;
                            }
                            else
                                waiting_time = 0;                     
                            if (temp_address < 255)
                                temp_address++;
#ifdef LCD_1602
                            lcd.printf(0, 1, "        ");    //  line# (0 or 1), string
                            lcd.printf(0, 1, "%d ", temp_address);    //  line# (0 or 1), string
#endif    
#ifdef YODA2
                            lcd.setAddress(0,1);
                            lcd.printf("        "); 
                            lcd.setAddress(0,1);
                            lcd.printf("%d ", temp_address);        
                            lcd.setAddress(0,1);                     
#endif                     
                        }
                        break;
                    default:
                        break;
                }
                break;                                   
            default:
                break;
        }
        wait(1);
    }
    
}
#endif