#include "mbed.h"
#include <HX711.h>
#include <eeprom.h>
#include <SB1602E.h>
#include "yoda2.h"
#include "TextLCD.h"
#if 1
extern EventFlags LCD_update_flags;
extern DigitalOut led1;
extern DigitalOut led2;
extern EEPROM ep;
#ifdef STM32F207xx
SB1602E lcd( PB_9, PB_8 );  //  SDA, SCL
#endif
#ifdef STM32F303xE
#ifdef LCD_1602
extern SB1602E lcd;  //  SDA, SCL
#endif
#ifdef YODA2
extern TextLCD_I2C_N lcd;
#endif
#endif
extern DigitalOut output1;
extern DigitalOut output2;
extern DigitalOut output3;
extern DigitalIn input1;
extern DigitalIn input2;
extern int current_weight;

ScaleCalibrationData customVar;

unsigned int calibration_ADC_value;
//#define CALIBRATION_VALUE   10    // 10g as the calibration weight


/* scale */
extern HX711 hx711;
long zero_value;
long calibration_value;
unsigned int calibration_times; // must calibration 3 times
unsigned int calibration_done = 0;
float scale_value;


/* scale */

void scaleCalibration(bool release_led)
{
    unsigned char eeprom_data[sizeof(customVar)];
    unsigned char checksum = 0;
    printf("Start Calibration.\r\n");
    if (release_led)
        LCD_update_flags.set(LCD_DISPLAY_HOLD_EVENT);
#ifdef LCD_1602  
    lcd.clear();
    lcd.printf(0, 0, "Calibration"); 
    lcd.printf(0, 1, "1.Empty the scale");
#endif    
#ifdef YODA2
    lcd.cls();
    lcd.setAddress(0,0);
    lcd.printf("Calibration"); 
    lcd.setAddress(0,1);
    lcd.printf("1.Empty the scale");
#endif
    calibration_done = 0;
    if (!calibration_done)
    {
        led1 = 1; 
        led2 = 0;
        if ((customVar.calibrationWeight > MAXIMUM_CALIBRATION_WEIGHT)||(customVar.calibrationWeight < MINIMUM_CALIBRATION_WEIGHT))
            customVar.calibrationWeight = CALIBRATION_WEIGHT;
        zero_value = hx711.averageValue(10); // skip first 10 readings
        zero_value = hx711.averageValue(20);
        printf("zero_value=%d \r\n", zero_value);
#ifdef LCD_1602         
        lcd.clear();
        lcd.printf(0, 0, "Calibration"); 
        lcd.printf(0, 1, "2.put %dg weights", customVar.calibrationWeight);
#endif        
#ifdef YODA2
        lcd.cls();
        lcd.setAddress(0,0);
        lcd.printf("Calibration"); 
        lcd.setAddress(0,1);
        lcd.printf("2.put %dg weights", customVar.calibrationWeight);
#endif
        calibration_value = 0;
        scale_value = 0;
        calibration_times = 0;
        led2 = 1;
        while (( calibration_times < 5))
        {
            calibration_value = hx711.averageValue(20);
            printf("calibration_value=%d\r\n", calibration_value);
            if (calibration_value > (zero_value + WEIGHT_DIFFERENCE))
            {
                calibration_times++;
            }
            else
                calibration_times = 0; 
        }
        printf("calibration_value=%d calibration_times=%d\r\n", calibration_value, calibration_times);
        if (calibration_times >=5)
        {
            // calibration is OK
            calibration_times = 0;
            scale_value = (calibration_value - zero_value) / customVar.calibrationWeight;
            customVar.offsetValue = zero_value;
            customVar.scaleValue = scale_value;
//               EEPROM.put(0x00, customVar);
            hx711.setOffset(zero_value);
            hx711.setScale(scale_value);      // this value is obtained by calibrating the scale with known weights; see the README for details
            memcpy(eeprom_data, &customVar, sizeof(customVar));
            for (int cnt = 0; cnt < (sizeof(customVar)-4); cnt++)  // compiler bug need to -4 here 
            {
               checksum += eeprom_data[cnt];
            }
            customVar.checksum = checksum;     
            printf("EEPROM write calibration data: \r\n");
            printf("calibrationWeight=%d \r\n", customVar.calibrationWeight);
            printf("offsetValue=%d \r\n", customVar.offsetValue);
            printf("scaleValue=%f \r\n", customVar.scaleValue);
            printf("checksum=0x%02x \r\n", customVar.checksum);    
            ep.write((uint32_t)0x00,(void *)&customVar,sizeof(customVar)); // write a structure eeprom_size - 32 
#ifdef LCD_1602                   
            lcd.clear();
            lcd.printf(0, 0, "Calibration"); 
            lcd.printf(0, 1, "Done");  
#endif    
#ifdef YODA2
            lcd.cls();
            lcd.setAddress(0,0);
            lcd.printf("Calibration"); 
            lcd.setAddress(0,1);
            lcd.printf("Done");
#endif        
            if (release_led)               
                LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);              
            calibration_done = 1;
            led1 = 1;   
            printf("Calibration Done\r\n");         
        }
    } 
    if (release_led)               
        LCD_update_flags.set(LCD_DISPLAY_RELEASE_EVENT);  
}

int change_calibrationWeight(unsigned int new_weight)
{
    unsigned char eeprom_data[sizeof(customVar)];
    unsigned char checksum = 0;    
    
    if ((new_weight <= MAXIMUM_CALIBRATION_WEIGHT)&&(new_weight > MINIMUM_CALIBRATION_WEIGHT))
        customVar.calibrationWeight = new_weight;    
    else
        return -1;
    memcpy(eeprom_data, &customVar, sizeof(customVar));
    for (int cnt = 0; cnt < (sizeof(customVar)-4); cnt++)  // compiler bug need to -4 here 
    {
       checksum += eeprom_data[cnt];
    }
    customVar.checksum = checksum;     
    printf("EEPROM write calibration data: \r\n");
    printf("calibrationWeight=%d \r\n", customVar.calibrationWeight);
    printf("offsetValue=%d \r\n", customVar.offsetValue);
    printf("scaleValue=%f \r\n", customVar.scaleValue);
    printf("checksum=0x%02x \r\n", customVar.checksum);    
    ep.write((uint32_t)0x00,(void *)&customVar,sizeof(customVar)); // write a structure eeprom_size - 32          
}

void init_scale()
{
    unsigned char eeprom_data;
    unsigned char checksum = 0;
    customVar.calibrationWeight = CALIBRATION_WEIGHT;

#if 1
    printf("sizeof(customVar)=%d \r\n", sizeof(customVar));
    ep.read((uint32_t)0,(void *)&customVar, sizeof(customVar)); 
    printf("EEPROM read calibration data: \r\n");
    printf("calibrationWeight=%d \r\n", customVar.calibrationWeight);
    printf("offsetValue=%d \r\n", customVar.offsetValue);
    printf("scaleValue=%f \r\n", customVar.scaleValue);
    printf("checksum=0x%02x \r\n", customVar.checksum);
    printf("\r\n calculate checksum: \r\n");
    for (int cnt = 0; cnt < (sizeof(customVar)-4); cnt++)  // compiler bug need to -4 here 
    {
        ep.read(cnt, (int8_t&)eeprom_data);
        printf("0x%02x ", eeprom_data);
        checksum += eeprom_data;
        printf("checksum=0x%02x\r\n", checksum);
    }
    printf("\r\ncalculated checksum=0x%02x \r\n", checksum);
    
    if (checksum == customVar.checksum)
    {
        if ((customVar.calibrationWeight > MAXIMUM_CALIBRATION_WEIGHT) || (customVar.calibrationWeight < MINIMUM_CALIBRATION_WEIGHT))
        {
            customVar.calibrationWeight = CALIBRATION_WEIGHT;
            scaleCalibration(true);
        }
        if ((customVar.offsetValue < 10000))
        {
            customVar.offsetValue = 10000;
            scaleCalibration(true);
        }
        if ((customVar.scaleValue < 100))
        {
            customVar.scaleValue = 100; 
            scaleCalibration(true);
        }
        //  delay(200);    
        hx711.setOffset(customVar.offsetValue);
        hx711.setScale(customVar.scaleValue);       
    }
    else
    {
        scaleCalibration(true);
    }
#endif  
}
void scale_reading()
{
    float weight;
    int gpioState1, gpioState2;
    uint32_t flags_read = 0;
    bool hold_lcd = true;
#ifdef LCD_1602     
    lcd.clear();
    lcd.printf(0, 0, "Weight (g)"); 
    lcd.printf(0, 1, "0 ");
#endif   
#ifdef YODA2
    lcd.cls();
    lcd.setAddress(0,0);
    lcd.printf("Weight (gram)"); 
    lcd.setAddress(0,1);
    lcd.printf("0 ");
#endif   
    while (true)
    {
        flags_read = LCD_update_flags.wait_any((LCD_DISPLAY_HOLD_EVENT|LCD_DISPLAY_RELEASE_EVENT), 10);
        if (flags_read == LCD_DISPLAY_HOLD_EVENT)
        {
            hold_lcd = false;
        }
        if (flags_read == LCD_DISPLAY_RELEASE_EVENT)
        {
            hold_lcd = true;
#ifdef LCD_1602             
            lcd.clear();
            lcd.printf(0, 0, "Weight (g)");    //  line# (0 or 1), string
#endif    
#ifdef YODA2
            lcd.cls();
            lcd.setAddress(0,0);
            lcd.printf("Weight (gram)"); 
#endif         
        }
        if (hold_lcd)
        {
            weight= hx711.getGram(5)+ 0.5;
            current_weight = (int)weight;
#ifdef LCD_1602             
            lcd.printf(0, 1, "        ");    //  line# (0 or 1), string
            lcd.printf(0, 1, "%d ", (int)weight );    //  line# (0 or 1), string
#endif           
#ifdef YODA2
            lcd.setAddress(0,1);
            lcd.printf("        ");
            lcd.setAddress(0,1);
            lcd.printf("%d ", (int)weight);
#endif  
        }
    }  
}
#endif
/*scale end*/