#include "mbed.h"
#include <HX711.h>
#include <eeprom.h>
#include "eeprom_cust.h"
//#include "digitLCD.h"
#include "SB1602E.h"
#include "yoda2.h"
#include "TextLCD.h"
#include "DS3231.h"


DigitalOut relay4(RELAY_4);
DigitalOut relay3(RELAY_3);
DigitalOut relay2(RELAY_2);
DigitalOut relay1(RELAY_1);
DigitalIn din1(DIN1);
DigitalIn din2(DIN2);
DigitalIn din3(DIN3);
DigitalIn din4(DIN4);
DigitalIn din5(DIN5);
DigitalIn din6(DIN6);
DigitalIn din7(DIN7);
DigitalIn din8(DIN8);

extern int moveMotor(int motornumber, int distance_mm, bool direction, bool freemove, bool gobackhome);
extern int moveMotor1(int distance_mm, bool direction, bool freemove, bool gobackhome);
extern int moveMotor2(int distance_mm, bool direction, bool freemove, bool gobackhome);
extern int moveMotor3(int distance_mm, bool direction, bool freemove, bool gobackhome);
extern int moveMotor3Until(bool direction, DigitalIn sensorpin);
extern DigitalOut motor3_pul;
extern DigitalOut motor3_en;
extern DigitalOut motor3_dir;

EventFlags button_event_flags;
EEPROM ep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C32);
extern void eeprom_test(void);
#ifdef YODA2
Serial uart1(PC_4, PC_5); // tx, rx
// I2C Communication
I2C i2c_lcd(LCD_SDA, LCD_SCL); // SDA, SCL
TextLCD_I2C_N lcd(&i2c_lcd, ST7032_SA, TextLCD::LCD16x2, NC, TextLCD::ST7032_3V3);
#endif
#if 1
int current_weight;
//EEPROM ep(SDA,SCL,EEPROM_ADDR,EEPROM::T24C256);
int device_address = DEVICE_DEFAULT_ADDRESS;  // address 11 bits: last 8 bits is device_address
int device_type;  //address 11 bits: first 3 bits is device_type
int init_id = 0x00300000;  // first 11 bit is the address
int init_filter_handle, broadcast_filter_handle;
int broadcast_id = 0x1ffC0000;
#endif


#if 1

EventFlags LCD_update_flags;
extern void main_menu();
extern void analyzePayload();
extern Device_Type_d device_type_v;
extern data_field_d can_txdata_frame;
extern CANMessage tx_message;
#if 1
#ifdef STM32F207xx
HX711 hx711(PB_11, PB_10);// data, clk
#endif

#ifdef STM32F303xE
//HX711 hx711(D8, D9);// data, clk
#ifdef OWN_SOLDER_BOARD
HX711 hx711(PA_14, PA_15);
#endif
#ifdef YODA2
HX711 hx711(SCALE_SDA, SCALE_SCL);
#endif
#endif
extern void scaleCalibration(bool release_led);
extern void init_scale();
Thread scale_thread;
extern void scale_reading();
#endif
unsigned char rx_buffer[8], tx_buffer[8];
unsigned char rx_length, tx_length;

//#define LCD_1602
#ifdef STM32F207xx
SB1602E lcd( PB_9, PB_8 );  //  SDA, SCL
CAN can1(PD_0, PD_1);
CAN can2(PB_5, PB_6);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
//FlashIAP flashIAP;

//#define LCD_1621
//digitLCD lcd(PA_5,PA_4,PB_5); // WO, CS, DATA
#endif
#ifdef STM32F303xE

#ifdef LCD_1602
SB1602E lcd(D14, D15 );  //  SDA, SCL
#endif
CAN can1(CAN_RD, CAN_TD); // RD, TD
DigitalOut led1(LED1);  // only one LED PA_5
DigitalOut led2(LED2);  // only one LED PA_5
#endif

#if 0
DigitalOut output1(PC_3);
DigitalOut output2(PC_2);
DigitalOut output3(PB_7);
DigitalIn input1(PC_6);
DigitalIn input2(PC_8);
#endif


uint8_t can_tx_data[8];
uint8_t can_rx_data[8];
#endif
void print_char(char c = '*')
{
    printf("%c\r\n", c);
    fflush(stdout);
}

#if 1
Thread can_receivethread;
Thread can_handlethread;
Thread mainmenu_thread;
bool can_register_success = false; 
CANMessage  msg;
MemoryPool<CANMessage, 16> can_mpool;
Queue<CANMessage, 16> can_queue;
#endif
InterruptIn button0(USER_BUTTON);
volatile bool button0_pressed = false; // Used in the main loop
volatile bool button0_enabled = true; // Used for debouncing
Timeout button0_timeout; // Used for debouncing
InterruptIn button1(BUTTON1);
volatile bool button1_pressed = false; // Used in the main loop
volatile bool button1_enabled = true; // Used for debouncing
Timeout button1_timeout; // Used for debouncing
InterruptIn button2(BUTTON2);
volatile bool button2_pressed = false; // Used in the main loop
volatile bool button2_enabled = true; // Used for debouncing
Timeout button2_timeout; // Used for debouncing
InterruptIn button3(BUTTON3);
volatile bool button3_pressed = false; // Used in the main loop
volatile bool button3_enabled = true; // Used for debouncing
Timeout button3_timeout; // Used for debouncing
InterruptIn button4(BUTTON4);
volatile bool button4_pressed = false; // Used in the main loop
volatile bool button4_enabled = true; // Used for debouncing
Timeout button4_timeout; // Used for debouncing


// Enables button when bouncing is over
//button0
void button0_enabled_cb(void)
{
    int button_status;
    button_status = button0.read();
    if (button_status == 0)
    {    
        printf("button0 down\r\n");
//        scaleCalibration(true);
        moveMotor3(100, true, true, false);
        button_status = button0.read();
        if (button_status == 0)
        {
            printf("button0 hold\r\n");
        }
        else
        {
            printf("button0 press hold and release\r\n");
        }
    }    
    else
        printf("button0 released\r\n");
    button0_enabled = true;
}

// ISR handling button pressed event
void button0_onpressed_cb(void)
{
    if (button0_enabled) { // Disabled while the button is bouncing
        button0_enabled = false;
        button0_pressed = true; // To be read by the main loop
        button0_timeout.attach(callback(button0_enabled_cb), 0.3); // Debounce time 300 ms
    }
}
//button0--
//button1
void button1_enabled_cb(void)
{
    int button_status;
    button_status = button1.read();
    if (button_status == 0)
    {    
        printf("button1 down\r\n");
        button_event_flags.set(BUTTON1_HOLD_EVENT);
    }    
    else
    {
        printf("button1 released\r\n");
        button_event_flags.set(BUTTON1_PRESSED_EVENT);
    }
    button1_enabled = true;
}

// ISR handling button pressed event
void button1_onpressed_cb(void)
{
    if (button1_enabled) { // Disabled while the button is bouncing
        button1_enabled = false;
        button1_pressed = true; // To be read by the main loop
        button1_timeout.attach(callback(button1_enabled_cb), 0.3); // Debounce time 300 ms
    }
}
//button1--
//button2
void button2_enabled_cb(void)
{
    int button_status;
    button_status = button2.read();
    if (button_status == 0)
    {    
        printf("button2 down\r\n");
        button_event_flags.set(BUTTON2_HOLD_EVENT);
    }    
    else
    {
        printf("button2 released\r\n");
        button_event_flags.set(BUTTON2_PRESSED_EVENT);        
    }
    button2_enabled = true;
}

// ISR handling button pressed event
void button2_onpressed_cb(void)
{
    if (button2_enabled) { // Disabled while the button is bouncing
        button2_enabled = false;
        button2_pressed = true; // To be read by the main loop
        button2_timeout.attach(callback(button2_enabled_cb), 0.3); // Debounce time 300 ms
    }
}
//button2--
//button3
void button3_enabled_cb(void)
{
    int button_status;
    button_status = button3.read();
    if (button_status == 0)
    {    
        printf("button3 down\r\n");
        button_event_flags.set(BUTTON3_HOLD_EVENT);        
    }    
    else
    {
        printf("button3 released\r\n");
        button_event_flags.set(BUTTON3_PRESSED_EVENT);  
    }
    button3_enabled = true;
}

// ISR handling button pressed event
void button3_onpressed_cb(void)
{
    if (button3_enabled) { // Disabled while the button is bouncing
        button3_enabled = false;
        button3_pressed = true; // To be read by the main loop
        button3_timeout.attach(callback(button3_enabled_cb), 0.3); // Debounce time 300 ms
    }
}
//button3--
//button4
void button4_enabled_cb(void)
{
    int button_status;
    button_status = button4.read();
    if (button_status == 0)
    {    
        printf("button4 down\r\n");
        button_event_flags.set(BUTTON4_HOLD_EVENT);         
    }    
    else
    {
        printf("button4 released\r\n");
        button_event_flags.set(BUTTON4_PRESSED_EVENT);   
    }
    button4_enabled = true;
}

// ISR handling button pressed event
void button4_onpressed_cb(void)
{
    if (button4_enabled) { // Disabled while the button is bouncing
        button4_enabled = false;
        button4_pressed = true; // To be read by the main loop
        button4_timeout.attach(callback(button4_enabled_cb), 0.3); // Debounce time 300 ms
    }
}
//button4--
#if 1
void can_sendData(int can_id, uint8_t *tx_data, int length)
{
    CANMessage txmsg;

    txmsg.format = CANExtended;
    txmsg.id = can_id;
    txmsg.len = length;
    txmsg.data[0] = tx_data[0];
    txmsg.data[1] = tx_data[1];
    txmsg.data[2] = tx_data[2];
    txmsg.data[3] = tx_data[3];
    txmsg.data[4] = tx_data[4];
    txmsg.data[5] = tx_data[5];
    txmsg.data[6] = tx_data[6];
    txmsg.data[7] = tx_data[7];                            
    
//    printf("can_sendData can_id=0x%08x \r\n", can_id);
    can1.write(txmsg);    
}

void can_rxthread()
{
    int loop;
    while (true) {
 #if 1      
        if(can1.read(msg)) {
            print_char();
            printf("got message id=%d 0x%08x\r\n", msg.id, msg.id);
//            b = *reinterpret_cast<int*>(msg.data);
            for (loop = 0; loop < msg.len; loop++)
            {
                can_rx_data[loop] = msg.data[loop];
            }
            
            printf("got data: length:%d\r\n", msg.len);
            for (loop = 0; loop < msg.len; loop++)
            {
                printf("data[%d]=%d\r\n", loop, can_rx_data[loop]);
            }           
//            if(msg.id == 1337) 
            {
                //only queue the message belongs to you
                CANMessage *can_message = can_mpool.alloc();
                memcpy((void *)can_message, (void *)&msg, sizeof(msg)); 
                if (!can_queue.full())
                    can_queue.put(can_message);
                else
                {
                    printf("message queue is full. \r\n");    
                }                
                led2 = !led2;
             }
        }
#endif
        wait(0.2);
    }
}
#endif
void i2c_scanner(PinName sda, PinName scl)
{
    I2C i2c(sda, scl); 
    
    int error, address;
    int nDevices;
    
    i2c.frequency(100000);
    printf("i2c_scanner sda=%d scl=%d \r\n", (int)sda, (int)scl); 
    printf("Scanning...\r\n");
    
    nDevices = 0;
    
    for(address = 0; address < 127; address++ ) 
    {
        i2c.start();
//        error = i2c.write(address << 1); //We shift it left because mbed takes in 8 bit addreses
        error = i2c.write(address << 1, "1", 1, false);
        i2c.stop();
        if (error == 0)
        {
          printf("I2C device found at address 7bit:0x%X (8bit:0x%X)\r\n", address, (address<<1)); //Returns 8-bit addres
          nDevices++;
        }
    }
    if (nDevices == 0)
        printf("No I2C devices found\r\n");
    else
        printf("\r\ndone\r\n");
}
int main()
{
    int loop = 0;
    int8_t ival;
    unsigned int can_id;
    int distance = 0;
#if 0    
    int hour;
    int minute;
    int second;

    int dayOfWeek;
    int date;
    int month;
    int year;
    DS3231 rtc_test(SDA, SCL);
//    DS3231 rtc_test(PF_0, PF_1);
//        printf("\r\n\nDS3231 Library test program\r\nremi cormier 2012\r\n\n");
    
    rtc_test.setI2Cfrequency(400000);
    
    //rtc_test.writeRegister(DS3231_Aging_Offset,0); // uncomment to set Aging Offset 1LSB = approx. 0.1 ppm according from datasheet = 0.05 ppm @ 21 °C from my measurments
     
    rtc_test.convertTemperature();
      
    int reg=rtc_test.readRegister(DS3231_Aging_Offset);
    if (reg>127)
        {reg=reg-256;}
    printf("Aging offset : %i\r\n",reg);
         
    printf("OSF flag : %i",rtc_test.OSF());
    printf("\r\n");
     
    rtc_test.readDate(&date,&month,&year);
    printf("date : %02i-%02i-%02i",date,month,year);
    printf("\r\n");
     
    rtc_test.setTime(19,48,45); // uncomment to set time
     
    rtc_test.readTime(&hour,&minute,&second);
    printf("time : %02i:%02i:%02i",hour,minute,second);
    printf("\r\n");
     
    rtc_test.setDate(6,22,12,2012); // uncomment to set date
 #endif   
    uart1.baud(115200);
    uart1.printf("\n\n*** Hello Yoda2! ***\r\n");
    printf("\n\n*** Hello Yoda2! ***\r\n");

//    wait(1);
#if 1
    ep.read((uint32_t)EEPROM_DEVICE_ADDRESS_ADDRESS,device_address); 
    printf("EEPROM: read device address:%d 0x%08x\r\n", device_address, device_address);
    if ((device_address == 0) || (device_address == 0xFFFFFFFF))
        device_address = DEVICE_DEFAULT_ADDRESS;
    device_type = (device_address & 0x00000700) >> 8;
    device_type_v = (Device_Type_d)device_type;
#ifdef LCD_1621
    lcd.clear();            // clears display
    lcd.allsegson();
   
 //   lcd.printf("ABCDEFGHI"); // Standard printf function, All ASCII characters will display
#endif  
#ifdef YODA2
#if 1
    lcd.cls();
    lcd.setContrast(31);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    lcd.setAddress(0,0);
    lcd.printf("Hello Yoda2!");
#endif    
#endif
#ifdef LCD_1602
//    lcd.printf( 0, "Hello world!" );    //  line# (0 or 1), string
//   lcd.printf( 1, "pi = %.6f", 3.14159265 );
//    lcd.putcxy(0x55, 5, 1);
//    lcd.printf(5, 0, "UUU");
//    lcd.printf(0, 0, "pressed!" );      
#endif   

//    input1.mode(PullUp);
//    input2.mode(PullUp);

//    can1.reset();
//    can2.reset();

#if 1
    printf("device_address =0x%08x \r\n", (device_address<<18));
    can1.frequency(100000);
    can1.filter((device_address<<18), 0x1FFC0000, CANExtended, init_filter_handle);  // 0x1FFC0000 to filter the last 18bits 0-17
    device_address = (device_address & 0x000000FF);
//only support one filter
//    can1.filter(broadcast_id, 0x1FFC0000, CANExtended, broadcast_filter_handle); // the broadcast id
//    can2.frequency(100000);
    //button0.mode(PullUp); // Activate pull-up
    can_receivethread.start(can_rxthread);  
    can_handlethread.start(analyzePayload);   
#endif    

#endif
    button1.mode(PullUp);
    button2.mode(PullUp);
    button3.mode(PullUp);
    button4.mode(PullUp);
    button0.fall(callback(button0_onpressed_cb)); // Attach ISR to handle button press event
    button0.rise(callback(button0_onpressed_cb)); // Attach ISR to handle button press event
    button1.fall(callback(button1_onpressed_cb)); // Attach ISR to handle button press event
    button1.rise(callback(button1_onpressed_cb)); // Attach ISR to handle button press event
    button2.fall(callback(button2_onpressed_cb)); // Attach ISR to handle button press event
    button2.rise(callback(button2_onpressed_cb)); // Attach ISR to handle button press event
    button3.fall(callback(button3_onpressed_cb)); // Attach ISR to handle button press event
    button3.rise(callback(button3_onpressed_cb)); // Attach ISR to handle button press event
    button4.fall(callback(button4_onpressed_cb)); // Attach ISR to handle button press event
    button4.rise(callback(button4_onpressed_cb)); // Attach ISR to handle button press event    
//    i2c_scanner(PB_9, PB_8);  
//    eeprom_test();

#if 1  
//    scaleCalibration(true);
    switch (device_type_v)
    {
        case CupTrack:  
            lcd.setAddress(0,1);
            lcd.printf("CupTrack ");
            break;
        case JamTrack:
            lcd.setAddress(0,1);
            lcd.printf("JamTrack ");
            break;
        case TeaTrack:
            lcd.setAddress(0,1);
            lcd.printf("TeaTrack ");
            break;
        case Tea:
            lcd.setAddress(0,1);
            lcd.printf("Tea ");
            init_scale();
            scale_thread.start(scale_reading);
            break;
        case Jam:
            lcd.setAddress(0,1);
            lcd.printf("Jam ");
            init_scale();
            scale_thread.start(scale_reading);
            break;
        case Shaker:
            lcd.setAddress(0,1);
            lcd.printf("Shaker ");
            break;
        default:
            break;        
    }
    lcd.printf("%d", device_address);
    mainmenu_thread.start(main_menu);

#endif
    moveMotor3(0, true, false, false);
    wait(2);
    while(1) {
        wait(2); 
#if 1              
        printf("Sensors:\r\n");
        printf("%d %d %d %d \r\n", din1.read(), din2.read(), din3.read(), din4.read());
        printf("%d %d %d %d \r\n", din5.read(), din6.read(), din7.read(), din8.read());    
        printf("Sensors:\r\n");
        printf("%d %d %d %d \r\n", din1.read(), din2.read(), din3.read(), din4.read());
        printf("%d %d %d %d \r\n", din5.read(), din6.read(), din7.read(), din8.read()); 
#endif
#if 0        
        distance = 0;
        distance = moveMotor3Until(true, din5);
        printf("F distance=%d \r\n", distance);       
        printf("Sensors:\r\n");
        printf("%d %d %d %d \r\n", din1.read(), din2.read(), din3.read(), din4.read());
        printf("%d %d %d %d \r\n", din5.read(), din6.read(), din7.read(), din8.read());  
        wait(1);
        distance = 0;
        distance = moveMotor3Until(false, din5);  
        printf("Sensors:\r\n");
        printf("%d %d %d %d \r\n", din1.read(), din2.read(), din3.read(), din4.read());
        printf("%d %d %d %d \r\n", din5.read(), din6.read(), din7.read(), din8.read()); 
        printf("B distance=%d \r\n", distance);
#endif
#if 0        
        relay4 = 1;
        printf("relay4 turn on\r\n");
        wait(2);
        relay3 = 1;
        printf("relay3 turn on\r\n");
        wait(2);        
        relay2 = 1;
        printf("relay2 turn on\r\n");
        wait(2);  
        relay1 = 1;
        printf("relay1 turn on\r\n");
        wait(2); 
        relay4 = 0;
        relay3 = 0;
        relay2 = 0;
        relay1 = 0;
#endif
#if 0        
        rtc_test.readDateTime(&dayOfWeek,&date,&month,&year,&hour,&minute,&second);
        printf("date time : %i / %02i-%02i-%02i %02i:%02i:%02i",dayOfWeek,date,month,year,hour,minute,second);
        printf("\r\n");
     
        printf("temperature :%6.2f", rtc_test.readTemp());
        printf("\r\n");
#endif        
#if 0
        moveMotor3(850, true, false, false);
        wait(5);
        moveMotor3(850, false, false, false);  
#endif        
#if 0             
        moveMotor1(100, true, false, false);
        moveMotor2(100, true, false, false);
        moveMotor3(100, true, false, false);
        wait(1);
        moveMotor1(150, true, false, false);
        moveMotor2(150, true, false, false);
        moveMotor3(150, true, false, false);
        wait(1);
        moveMotor1(250, false, false, false);
        moveMotor2(250, false, false, false);
        moveMotor3(250, false, false, false);
#endif        
#if 1        
        if (!can_register_success)
        {    
            can_txdata_frame.cmd = COMMAND_REGISTER;
            can_txdata_frame.value1 = 0;
            can_txdata_frame.value2 = 0;
            can_txdata_frame.value3 = 0;
            memcpy(can_tx_data, (unsigned char *)&can_txdata_frame, sizeof(can_tx_data));
//            printf("cmd=0x%08x value1=0x%08x size=%d %d\r\n", can_txdata_frame.cmd, can_txdata_frame.value1, sizeof(can_tx_data), sizeof(can_txdata_frame));
//            printf("data 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x \r\n", can_tx_data[0], can_tx_data[1], can_tx_data[2], can_tx_data[3], can_tx_data[4], can_tx_data[5], can_tx_data[6], can_tx_data[7]);  
            can_id = (RASPBERRY_PI_CAN_ADDRESS << 18) | (((device_type << 8) |device_address) << 7) | 0x80000000;
//            printf("device_address = 0x%08x can_id=0x%08x \r\n", device_address, can_id);
            can_sendData(can_id, can_tx_data, 8);        
        }
#endif        
    }

#if 0
    int idx = 0; // Just for printf below
    can_tx_data[0] = 0;
    while(1) {
        if (button0_pressed) { // Set when button is pressed
#if 0        
            printf("scale value %f. \r\n", hx711.getGram());
#endif
            can_tx_data[1] = can_tx_data[0]+1;
            can_tx_data[2] = can_tx_data[1]+1;
            can_tx_data[3] = can_tx_data[2]+1;
            can_tx_data[4] = can_tx_data[3]+1;
            can_tx_data[5] = can_tx_data[4]+1;
            can_tx_data[6] = can_tx_data[5]+1;
            can_tx_data[7] = can_tx_data[6]+1; 
            button0_pressed = false;
            printf("Button pressed %d\r\n", idx++);
            printf("ID=%d data[0]=%d. \r\n", init_id + idx%10, can_tx_data[0]);
#ifdef LCD_1602
            lcd.printf(0, 0, "%d ", idx );    //  line# (0 or 1), string
#endif   
            can1.write(CANMessage((init_id + idx%10), reinterpret_cast<char*>(can_tx_data), 8, CANData,CANExtended));            
            led1 = !led1;
            can_tx_data[0]++;
        }
    }
#endif
  
}
