/*
 * http://mbed.org/cookbook/Text-LCD-Enhanced
 */
 
#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x4); //

int main() {

    pc.printf("LCD Test. Columns=%d, Rows=%d\n\r", lcd.columns(), lcd.rows());
    
    for (int row=0; row<lcd.rows(); row++) {
      int col=0;
      
      pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));      
//      lcd.putc('-');
      lcd.putc('0' + row);      
      
      for (col=1; col<lcd.columns()-1; col++) {    
        lcd.putc('*');
      }
 
      pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));      
      lcd.putc('+');
        
    }    
    
// Show cursor as blinking character
    lcd.setCursor(TextLCD::CurOff_BlkOn);
 
// Set and show user defined characters. A maximum of 8 UDCs are supported by the HD44780.
// They are defined by a 5x7 bitpattern. 
    lcd.setUDC(0, (char *) udc_0);  // Show |>
    lcd.putc(0);    
    lcd.setUDC(1, (char *) udc_1);  // Show <|
    lcd.putc(1);    
    lcd.setUDC(2, (char *) udc_2);
    lcd.putc(2);    
    lcd.setUDC(3, (char *) udc_3);
    lcd.putc(3);    
    lcd.setUDC(4, (char *) udc_4);
    lcd.putc(4);    
    lcd.setUDC(5, (char *) udc_5);
    lcd.putc(5);    
    lcd.setUDC(6, (char *) udc_6);
    lcd.putc(6);    
    lcd.setUDC(7, (char *) udc_7);
    lcd.putc(7);     

}