#include "mbed.h"
#include "w5100.h"
#include "ipaddr.h"
#include "TCPSocket.h"
#include  "html.h"
#include "sstream"
#include "httpServer.h"
//#include "SDFileSystem.h"

#include "test.h"

extern W5100Class W5100;

Serial pc(D1, D0);
Timer sendStatusTimer;
Timer pollUDPTimer;
Ticker tickTCP;

int globalCounter = 0;

DigitalOut myled(LED1);

httpServer webServer(0);

#ifdef SDCARD_
SDFileSystem sd(D4, D5, D3, D2, "sd");
#endif
int main()
{
    IpAddr localhost(192,168,1,68);
    IpAddr netmask(255,255,255,0);
    IpAddr gateway(192,168,1,1);

    // Verzögerung um das Terminal einzuschalten
    wait(5);

    // Serielle Schnittstelle initialisieren
    pc.baud(115200);

    // Initialisieren des Ethernetinterfaces
    pc.printf("Etbernet initialisieren.\n");
    W5100.hardware_reset();
    W5100.init();

    uint8_t mac[6] = {0x00,0x00,0x5e,0x00,0x01,0x01};
    W5100.setMACAddress(mac);

    uint8_t u[4];
    localhost.getIP(u);
    W5100.setIPAddress(u);

    netmask.getIP(u);
    W5100.setSubnetMask(u);

    gateway.getIP(u);
    W5100.setGatewayIp(u);

    // Sendetimer starten (und anschließend per Polling abfragen)
    pc.printf("Sendetimer starten.\n");
//    sendStatusTimer.start();

#ifdef SDCARD_
    pc.printf("sd.disk_status = %x", sd.disk_status());


    mkdir("/sd/mydir", 0777);

    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        printf("Could not open file for write\n");
    } else {
        fprintf(fp, "Hello fun SD Card World!");
        fclose(fp);
    }
#endif

    // TCP starten und regelmäßig bedienen
    webServer.start(80);
    tickTCP.attach(&webServer, &httpServer::poll, 0.1);

    while(1) {
        /*
                // nach Ablauf der Wartezeit die STatusinformationen per Serieller Schnittstelle senden
                if (sendStatusTimer.read_ms() >= 2000) {
                    sendStatusTimer.reset();
                    pc.printf("(main) SnSR = 0x%d\n",W5100.readSnSR(0));
                }
                */
    }
}
