#ifndef IPADDR_H
#define IPADDR_H
#include <stdint.h>

class IpAddr
{
    public:
        IpAddr();
        IpAddr(uint8_t ip0, uint8_t ip1, uint8_t ip2, uint8_t ip3);
        
        bool isNull();
        bool isEqual(IpAddr *addr2);
        int getIpPart(uint8_t i);
        
        bool isSameSubnet(IpAddr * addr2, IpAddr * netmask);
        
        bool operator==(IpAddr * rhs);
        bool operator==(IpAddr &rhs);
        
        void getIP(uint8_t *ip);
        
    private:
        uint8_t m_ip[4];
};

#endif
