#include "ipaddr.h"

using namespace std;

IpAddr::IpAddr()
{
    m_ip[0] = 0;
    m_ip[1] = 0;
    m_ip[2] = 0;
    m_ip[3] = 0;
}

IpAddr::IpAddr(uint8_t ip0, uint8_t ip1, uint8_t ip2, uint8_t ip3)
{
    m_ip[0] = ip0;
    m_ip[1] = ip1;
    m_ip[2] = ip2;
    m_ip[3] = ip3;
}

bool IpAddr::isNull()
{
    if ( m_ip[0]==0 & m_ip[1]==0 & m_ip[2]==0 & m_ip[3]==0)
        return true;
    else
        return false;
}

int IpAddr::getIpPart(uint8_t i)
{
    return m_ip[i];
}

bool IpAddr::isEqual(IpAddr *addr2)
{
    if (this->getIpPart(0) != addr2->getIpPart(0)) return false;
    if (this->getIpPart(1) != addr2->getIpPart(1)) return false;
    if (this->getIpPart(2) != addr2->getIpPart(2)) return false;
    if (this->getIpPart(3) != addr2->getIpPart(3)) return false;
    return true;
}

// liefert zurück, ob sich die gewählte und "addr2" im gleichen Subnetz befinden
bool IpAddr::isSameSubnet(IpAddr * addr2, IpAddr * netmask)
{
    int hv1, hv2;

    for (int i=0; i<4; i++) {
        hv1 = ((this->getIpPart(i) & netmask->getIpPart(i)));
        hv2 = ((addr2->getIpPart(i) & netmask->getIpPart(i)));
        if (hv1 != hv2) return false;
    }
    return true;
}

bool IpAddr::operator==(IpAddr * rhs)
{
    for (int i=0; i<4; i++) {
        if ((this->getIpPart(i)  != rhs->getIpPart(i))) return false;
    }
    return true;
}

bool IpAddr::operator==(IpAddr & rhs)
{
    for (int i=0; i<4; i++) {
        if ((this->getIpPart(i)  != rhs.getIpPart(i))) return false;
    }
    return true;
}


void IpAddr::getIP(uint8_t * ip)
{
    for(int i=0; i<4; i++) {
        ip[i] = m_ip[i];
    }
}