#include "httpServer.h"
#include <cstring>

extern Serial pc;

httpServer::httpServer(int socket)
{
    tcpSocket.setSocket(socket);
}

void httpServer::start(int port)
{
    _port = port;
    tcpSocket.attach(this, &httpServer::httpApp);
    tcpSocket.bind(port);
    timeout.start();
    counter = 0;
}

void httpServer::close()
{
}

// zyklisch aufzurufende Funktion, die das System handled
void httpServer::poll()
{
    tcpSocket.poll();
}

// Programm um den Datenstrom zu handeln
void httpServer::httpApp()
{
    char buf[2048];
    char * ptrToken;

    // Größe des Empfangspuffers einlesen
    int size = tcpSocket.getRxSize();

    counter++;

    pc.printf("\n\n!! Was  empfangen (%d)(%d)\n\n", _port, size);

    if (size > 0) {
        // Daten in den buffer buf lesen
        size = tcpSocket.recv(buf, sizeof(buf));
        timeout.reset();        // wenn aktivität ist den timer zurück setzen

        // Abfragetyp erkennen (GET oder POST)
        ptrToken = strtok(buf, " /&\r\n");

        if (strncmp(ptrToken, "GET", strlen("GET")) == 0) {
            pc.printf("GET\n", _port, size);

            // Erkenne die Anfrage
            ptrToken = strtok(NULL, " /&\r\n");

            if (strncmp(ptrToken, "test", strlen("test")) == 0) {
                tcpSocket.send(c_HTTP_200_OK, strlen(c_HTTP_200_OK));
                tcpSocket.send(c_HTTP_CacheControl_NoCache, strlen(c_HTTP_CacheControl_NoCache));
                tcpSocket.send(c_HTTP_Content_HTML, strlen(c_HTTP_Content_HTML));

                tcpSocket.send(c_HTTP_EmptyLine, strlen(c_HTTP_EmptyLine));
                tcpSocket.send(html_head, strlen(html_head));

            } else if (strncmp(ptrToken, "zeit", strlen("zeit")) == 0) {
                tcpSocket.send(c_HTTP_200_OK, strlen(c_HTTP_200_OK));
                tcpSocket.send(c_HTTP_CacheControl_NoCache, strlen(c_HTTP_CacheControl_NoCache));
                tcpSocket.send(http_refresh, strlen(http_refresh));

                tcpSocket.send(c_HTTP_Content_HTML, strlen(c_HTTP_Content_HTML));

                tcpSocket.send(c_HTTP_EmptyLine, strlen(c_HTTP_EmptyLine));
                tcpSocket.send(html_head, strlen(html_head));

                //sprintf(buf, "Zaehler : %d \r\n\r\n", counter);

                tcpSocket.send(html_table_head, strlen(html_table_head));

                for (int i=0; i<10; i++) {
                    //sprintf(buf, "Zaehler : %d, %d \r\n\r\n", counter, i);
                    sprintf(buf, "<tr><th>%d</th><th>%d</th><th>%d</th></tr>", counter, i, counter*counter);
                    tcpSocket.send(buf, strlen(buf));
                }

                tcpSocket.send(html_table_foot, strlen(html_table_foot));
                tcpSocket.send(html_foot, strlen(html_foot));


            } else {
                tcpSocket.send(c_HTTP_404_NotFound, strlen(c_HTTP_404_NotFound));
                tcpSocket.send(c_HTTP_CacheControl_NoCache, strlen(c_HTTP_CacheControl_NoCache));
                tcpSocket.send(c_HTTP_Content_HTML, strlen(c_HTTP_Content_HTML));
                tcpSocket.send(c_HTTP_EmptyLine, strlen(c_HTTP_EmptyLine));
                tcpSocket.send(c_HTTP_Page_404, strlen(c_HTTP_Page_404));
            }

        } else {
            pc.printf("POST\n");
        }


    } else {
        if (timeout.read_ms() > 500) {
            pc.printf("Socket schließen.\n");
            tcpSocket.close();
            timeout.reset();
        }
    }
}