#ifndef TCPSOCKET_H
#define TCPSOCKET_H

#include "ipaddr.h"
#include "mbed.h"

class TCPSocket
{
    int _socket;
    int _port;
    void (*m_pCb)(void);
    void (*_tptr)(void);
    void (*_mptr) (void);
    int pointertype;

protected:
    FunctionPointer _callbackHandler;

public:
    TCPSocket();
    TCPSocket(int newSocket);

    void setSocket(int socket);

    void bind(int port);
    void listen();
    void close();
    int send(const char* buf, int len);
    int recv(char* buf, int len);
    void poll();
    void setOnEvent(void (*pMethod)(void));
    template<typename T>
    void setOnEvent(T* tptr, void (T::*mptr)(void));

    // Handler für eine non-member Funktion hinzufügen
    void attach(void (*function)(void)) {
        _callbackHandler.attach( function );
    }

    template<typename T>
    void attach(T* object, void (T::*member)(void)) {
        _callbackHandler.attach( object, member );
    }
    
    int getRxSize();
};
#endif // MYUDPSOCKET_H
