
#include "TCPSocket.h"
#include "ipaddr.h"
#include "w5100.h"
#include "mbed.h"

extern Serial pc;

TCPSocket::TCPSocket(int newSocket)
{
    _socket = newSocket;
}

TCPSocket::TCPSocket()
{
}

void TCPSocket::setSocket(int socket)
{
    pc.printf("setSocket() = %d \n", _socket);
    _socket = socket;
}

void TCPSocket::bind(int port)
{
    pc.printf("bind()= %d \n", _socket);
    _port = port;
    W5100.writeSnMR(_socket, SnMR::TCP); // set TCP mode
    W5100.writeSnPORT(_socket, _port);
}

void TCPSocket::listen()
{
    pc.printf("listen()= %d \n", _socket);
    W5100.execCmdSn(_socket, Sock_OPEN); // set OPEN command
    W5100.execCmdSn(_socket, Sock_LISTEN); // listen
}



int TCPSocket::send(const char* buf, int len)
{
    if (len > 0) {
        W5100.send_data_processing(_socket, (uint8_t*)buf, len);
        W5100.execCmdSn(_socket, Sock_SEND);
    }
    return len;
}

int TCPSocket::recv(char* buf, int len)
{
    int size = W5100.getRXReceivedSize(_socket);
    if (size > len) {
        size = len;
    }

    if (size > 0) {
        W5100.recv_data_processing(_socket, (uint8_t*)buf, size);
        W5100.execCmdSn(_socket, Sock_RECV);
    }

    return size;
}

void TCPSocket::poll()
{
    // status abfragen
    uint8_t Sn_SR = W5100.readSnSR(_socket);
    pc.printf("(sock) SnSR = 0x%x\n", Sn_SR);

    switch(Sn_SR) {
        case SnSR::CLOSED:
            listen();           // wenn Socket geschlossen, dann öffnen
            break;

        case SnSR::LISTEN:      // weiter warten
            break;

        case SnSR::ESTABLISHED: // Kontrolle, und App abarbeiten
            _callbackHandler.call();
            break;

        case SnSR::FIN_WAIT:    // für die folgenden Fälle den Port schließen
        case SnSR::CLOSING:
        case SnSR::TIME_WAIT:
        case SnSR::CLOSE_WAIT:
        case SnSR::LAST_ACK:
            close();
            break;

        default:                // Sonst --> nichts machen
            break;
    }
}

void TCPSocket::close()
{
    if (_socket != (-1)) {
        W5100.execCmdSn(_socket, Sock_DISCON);
        W5100.execCmdSn(_socket, Sock_CLOSE);
    }
}

void TCPSocket::setOnEvent(void (*pMethod)(void))
{
    m_pCb = pMethod;
    pointertype = 0;
}

int TCPSocket::getRxSize()
{
    return W5100.readSnRX_RSR(_socket);
}