/*****************************************************************************
 * New Probe development
 * RHT-03
 *
 */

#include "mbed.h"
#include "DHT.h"
 
Serial pc(USBTX, USBRX);
 
DHT Probe1(PTA4,RHT03); // Define the device

int main()
{
    int err;
    static float temp_F, temp_C;
    static float humidity;
    static float dew_pt_C, dew_pt_F;      
 
    while(1)
    {
        err = Probe1.readData();
        if (err == 0)
        {
            temp_F    = Probe1.ReadTemperature(FARENHEIT);
            temp_C    = Probe1.ReadTemperature(CELCIUS);
            humidity  = Probe1.ReadHumidity();
            dew_pt_C         = Probe1.CalcdewPoint(temp_C, humidity);
            dew_pt_F         = dew_pt_C * 9 / 5 + 32;
             
            pc.printf("P2: Temp = %4.2f F Humidity = %4.2f DewPt = %4.2f  \r\n",
               temp_F, humidity, dew_pt_F);
        }
        else
        {
            pc.printf("error %d \r\n", err);
        }  
        
        wait(3);  
    }
}

