#include "mbed.h"
#include "stepper.h"

void stepperMotor::moveStepper()
{
    if(remain == 0 || limitSwitch.read() == 0)
    {
        remain = 0;
        return;
    }
    if(step)
    {
        step = 0; //STEP 1->0
        remain--;
    }
    else
    {
        step = 1; //STEP 0->1
    }
}

void stepperMotor::enable()
{
    en = 0;
}

void stepperMotor::enable(int inputRemain)
{
    setDir(inputRemain >= 0? true: false);
    remain = inputRemain >= 0? inputRemain: -inputRemain;
    enable();
}

void stepperMotor::disable()
{
    remain = 0;
    en = 1;
}

void stepperMotor::pause()
{
    en = 1;
}

void stepperMotor::setDir(bool direction)
{
    dir = direction;
}

stepperMotor::stepperMotor(PinName stepPin, PinName dirPin, PinName enPin, PinName limitSwitchPin, float period): 
    remain(0), step(stepPin), dir(dirPin), en(enPin), limitSwitch(limitSwitchPin)
{
    disable();
    //limitSwitch.mode(PullUp);
    stepper.attach(this, &stepperMotor::moveStepper, period);
}
