/*********************************************************************************
* This test program loads a large array of const strings, then reports how much
* RAM is still available.
*
* Without the array, 24,196 bytes of RAM are free.
* With an 8000-char array, 13,476 bytes of RAM are free 
* The const string of 8000 chars thus consumes 10720 bytes of RAM.
*********************************************************************************/
#include "mbed.h"
#include <string>

DigitalOut fan(p21);        // Needed for my breadboard

#define TEST8000          // Comment this line to find the baseline value for free RAM

#ifdef TEST8000
// teststring is an array of 100 x 80 character strings
const string teststring[] = {
     "This is the first line of 100 80-character strings in the 'teststring[]' array.",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",
     "0123456789012345678901234567890123456789012345678901234567890123456789012345678",   
 };
#endif

int main() { 
     int low = 0;
     int high = 0x8001;     
     fan = 0;

#ifdef TEST8000     
     // Include at least one reference to the array, to keep the optimizer happy
     printf("The first string is %s\r\n", teststring[0]);
#endif
     
     // Compute free memory, using Segundo Equipo's AvailableMemory.cpp code
    __disable_irq(); 
     while (high - low > 1) {
         int mid = (low + high) / 2;
         void* p = malloc(mid);
         if (p == NULL) {
             high = mid;
         } else {
             free(p);
             low = mid;
         }
     }
    __enable_irq();
 
     printf("Test program 'stringtest' reports space available in RAM = %d\r\n", low);
}
