 /* mbed Library - CaptureT0_11U24
 * Copyright (c) 2014
 * released under MIT license http://mbed.org/licence/mit
 */
 
/***********************************************************************//**
 * @file        capturet1_11u24.h
 * @brief       Header file for the CaptureT0_11U24 library. 
 * @version     0.0
 * @date        5 Feb 2014
 * @author      
 **************************************************************************/
/***************************************************************************
 * Revision     Date        Comments
 *----------    --------    -----------------------------------------------
 *
 *  0.0         2/5/14    Initial creation
 ***************************************************************************/

#ifndef CAPTURET0_H
#define CAPTURET0_H

/* Includes ------------------------------------------------------------------- */
#include "mbed.h"


/* Public Types --------------------------------------------------------------- */


/* Public Functions ----------------------------------------------------------- */
/** @defgroup Capture_Public_Functions Capture Public Functions
*/
class Capture {
public:

/** Create a Capture object and configure it
 *
 * @param none
 */
Capture(void);

/** Start capturing data. Accumulate the specified number of samples. 
 * @param numsamples    The number of samples to be accumulated
 * @return        None
 */
void Start(int numsamples);

/** Check to see if a new count is ready. 
 * 
 * @return       (int) Status value. Negative means overrun.
 */
int Ready(void);

/** Read (accumlated) sample count. 
 * 
 * @return       (unsigned int) Accumulated capture value
 */
unsigned int Read(void);



/* Public Macros -------------------------------------------------------------- */




private:
static void _Captureisr(void);
void Captureisr(void);  
static Capture *instance;
int flag;
int channel;
//int capturecount;
unsigned int capturedata;
int Nsamples;
//int Nsamplebits;
//int *flagaddresspointer;



/* Private Macros ------------------------------------------------------------- */
/* --------------------- BIT DEFINITIONS -------------------------------------- */
/* Timer Capture Register Definitions --------------------- */

/*********************************************************************//**
 * Macro defines for CT32B0->IR Interrupt tegister
 **********************************************************************/
#define IR_CR1INT                   ((uint32_t)(1<<6))        /**< Interrupt flag for capture channel 1 */

/*********************************************************************//**
 * Macro defines for IOCON->PIO1_29 register bits LPC11U24
 **********************************************************************/
#define PIN_PULL_UP                     2UL
#define PIN_REPEATER                    3UL
#define PIN_NORESISTOR                  0UL
#define PIN_PULL_DOWN                   1UL 

/* FUNC bits */
#define CT32B0_CAP1                     2UL

/* MODE bits */
#define CAP_PULLUP                 ((uint32_t)(PIN_PULL_UP<<3))          // Pull up on the CT32B0_CAP1 input pin

/*********************************************************************//**
 * Macro defines for SYSCON->SYSAHBCLKDIV register  bits LPC11U24
 **********************************************************************/
#define CT32B0_CLK_ENABLE          ((uint32_t)(1<<9))        /**< CT32B0 clock enable */ 

/*********************************************************************//**
 * Macro defines for CT32B0->TCR register  bits LPC11U24
 **********************************************************************/
#define TCR_CEN                         1UL


/*********************************************************************//**
 * Macro defines for CT32B0->CCR register  bits LPC11U24
 **********************************************************************/
#define CCR_CAP1RE                     ((uint32_t)(1<<6)) 
#define CCR_CAP1FE                     ((uint32_t)(1<<7))
#define CCR_CAP1I                      ((uint32_t)(1<<8))  

/*********************************************************************//**
 * Macro defines for CT32B0->CTCR register  bits LPC11U24
 **********************************************************************/
#define CTCR_CTM_TIMER                  0UL
#define CTCR_ENCC                       ((uint32_t)(1<<4))
#define CTCR_SEICC_CAP1RE               ((uint32_t)(4<<5))



}; // End of Capture class information
#endif /* CAPTURE_H */
/* --------------------------------- End Of File ------------------------------ */
