/*=============================================================================================
        section 1 - includes
 ==============================================================================================*/
/* imported libs */
#include "mbed.h"
#include "stm32746g_discovery_qspi.h"

/* project files */
#include "flash.h"

/*=============================================================================================
        section 2 - private defines / enumerations
 ==============================================================================================*/
#define FLASH_START_ADDRESS 0
#define FLASH_START_BLOCK   0

/*=============================================================================================
        section 3 - private typedefs
 ==============================================================================================*/

/*=============================================================================================
        section 4 - private macros
 ==============================================================================================*/
 
/*=============================================================================================
        section 5 - public constants definition
 ==============================================================================================*/

/*=============================================================================================
        section 6 - public variables/pointers definition
 ==============================================================================================*/

/*=============================================================================================
        section 7 - private constants definition
 ==============================================================================================*/

/*=============================================================================================
        section 8 - private variables/objects/pointers definition
 ==============================================================================================*/
static uint8_t localFlashData[FLASH_DATA_SIZE];

/*=============================================================================================
        section 9 - private functions - declaration
 ==============================================================================================*/

/*=============================================================================================
        section 10 - private functions - implementation (definition)
 ==============================================================================================*/

/*=============================================================================================
        section 11 - public functions - implementation (definition)
 ==============================================================================================*/
void flash_init(void) 
{
    BSP_QSPI_Init(); 
    BSP_QSPI_Read(localFlashData, FLASH_START_ADDRESS, FLASH_DATA_SIZE);
}

/* liest Flash Daten aus der lokale RAM Kopie */
uint8_t flash_read(E_FLASH_INDEX index)
{
    return localFlashData[index];
}

/* schreibt Flash Daten in die lokale RAM Kopie */
void flash_write(E_FLASH_INDEX index, uint8_t data)
{
    localFlashData[index] = data;
}

void flash_task(void)
{
    uint8_t tmpFlashData[FLASH_DATA_SIZE];
    uint8_t isNotEqual = 0;
    uint8_t i;
    
    /* prüfe ob die RAM Daten != den ROM Daten sind */
    BSP_QSPI_Read(tmpFlashData, FLASH_START_ADDRESS, FLASH_DATA_SIZE);
    for (i = 0; i < FLASH_DATA_SIZE; i++)
    {
        if (tmpFlashData[i] != localFlashData[i])
        { /* Daten ungleich */
            isNotEqual = 1; 
        }
    }
    
    /* schreibe RAM Daten in das Flash ROM falls RAM Daten != ROM Daten */
    if (1 == isNotEqual)
    {
        BSP_QSPI_Erase_Block(FLASH_START_BLOCK);
        BSP_QSPI_Write(localFlashData, FLASH_START_ADDRESS, FLASH_DATA_SIZE);
    }
}

/*=============================================================================================
        section 12 - interrupt service routines (ISRs)
 ==============================================================================================*/

/*=============================================================================================
        end of file
 ==============================================================================================*/